/*
 * Decompiled with CFR 0.152.
 */
package com.skmedix.bootstrap.internal.jbeat;

import com.skmedix.bootstrap.internal.jbeat.Shared;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;

public final class Patcher {
    private static final int MAX_FILE_SIZE = 0x7FFFFFF7;
    private final Path patchFile;
    private final Path sourceFile;
    private final Path targetFile;

    public Patcher(Path patchFile, Path sourceFile, Path targetFile) {
        this.patchFile = patchFile;
        this.sourceFile = sourceFile;
        this.targetFile = targetFile;
    }

    public void patch() throws IOException {
        byte[] patchBytes = Files.readAllBytes(this.patchFile);
        byte[] sourceBytes = Files.readAllBytes(this.sourceFile);
        long patchLength = patchBytes.length;
        ByteBuffer patch = ByteBuffer.wrap(patchBytes);
        ByteBuffer source = ByteBuffer.wrap(sourceBytes);
        for (char c : Shared.magicHeader) {
            if (patch.get() == c) continue;
            throw new IOException("Patch file does not contain correct BPS header!");
        }
        long sourceSize = this.decode(patch);
        long targetSize = this.decode(patch);
        this.validateFileSize(targetSize, "Target file");
        ByteBuffer target = ByteBuffer.allocate((int)targetSize);
        String metadata = this.readString(patch);
        int sourceOffset = 0;
        int targetOffset = 0;
        while ((long)patch.position() < patchLength - 12L) {
            long length = this.decode(patch);
            long mode = length & 3L;
            length = (length >> 2) + 1L;
            if (mode == 0L) {
                while (length-- != 0L) {
                    target.put(source.get(target.position()));
                }
                continue;
            }
            if (mode == 1L) {
                while (length-- != 0L) {
                    target.put(patch.get());
                }
                continue;
            }
            long data = this.decode(patch);
            long offset = (long)((data & 1L) != 0L ? -1 : 1) * (data >> 1);
            if (mode == 2L) {
                sourceOffset = (int)((long)sourceOffset + offset);
                while (length-- != 0L) {
                    target.put(source.get(sourceOffset++));
                }
                continue;
            }
            targetOffset = (int)((long)targetOffset + offset);
            while (length-- != 0L) {
                target.put(target.get(targetOffset++));
            }
        }
        patch.order(ByteOrder.LITTLE_ENDIAN);
        long sourceChecksum = this.readInt(patch);
        if (Shared.checksum(source, sourceSize) != sourceChecksum) {
            throw new IOException("Source checksum does not match!");
        }
        long targetChecksum = this.readInt(patch);
        if (Shared.checksum(target, targetSize) != targetChecksum) {
            throw new IOException("Target checksum does not match!");
        }
        long patchChecksum = this.readInt(patch);
        if (Shared.checksum(patch, patchLength - 4L) != patchChecksum) {
            throw new IOException("Patch checksum does not match!");
        }
        Files.write(this.targetFile, target.array(), new OpenOption[0]);
    }

    private void validateFileSize(long size, String fileName) throws IOException {
        if (size > 0x7FFFFFF7L) {
            throw new IOException(fileName + " size exceeds maximum supported size (" + 0x7FFFFFF7 + " bytes): " + size);
        }
    }

    private String readString(ByteBuffer in) {
        int length = (int)this.decode(in);
        String ret = null;
        if (length != 0) {
            int limit = in.limit();
            in.limit(in.position() + length);
            ret = Shared.charset.decode(in).toString();
            in.limit(limit);
        }
        return ret;
    }

    private long readInt(ByteBuffer in) {
        return (long)in.getInt() & 0xFFFFFFFFL;
    }

    private long decode(ByteBuffer in) {
        long data = 0L;
        long shift = 1L;
        while (true) {
            byte x = in.get();
            data += (long)(x & 0x7F) * shift;
            if ((x & 0x80) != 0) break;
            data += (shift <<= 7);
        }
        return data;
    }
}

