/*
 * Decompiled with CFR 0.152.
 */
package pl.skmedix.bootstrap;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.text.DateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.NonOptionArgumentSpec;
import joptsimple.OptionException;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import pl.skmedix.bootstrap.BootstrapConstants;
import pl.skmedix.bootstrap.IUserInterface;
import pl.skmedix.bootstrap.Log;
import pl.skmedix.bootstrap.SwingUserInterface;
import pl.skmedix.bootstrap.task.TaskContext;
import pl.skmedix.bootstrap.task.TaskExecutor;
import pl.skmedix.bootstrap.task.TaskResult;
import pl.skmedix.bootstrap.task.impl.CleanupTask;
import pl.skmedix.bootstrap.task.impl.ConditionalTask;
import pl.skmedix.bootstrap.task.impl.ConfigurationTask;
import pl.skmedix.bootstrap.task.impl.DependencyTask;
import pl.skmedix.bootstrap.task.impl.FileUpdateTask;
import pl.skmedix.bootstrap.task.impl.FileValidationTask;
import pl.skmedix.bootstrap.task.impl.LauncherStartTask;
import pl.skmedix.bootstrap.task.impl.MirrorDiscoveryTask;
import pl.skmedix.bootstrap.task.impl.PatchTask;
import pl.skmedix.bootstrap.task.impl.VersionCheckTask;
import pl.skmedix.bootstrap.ui.swing.AlertUtils;
import pl.skmedix.bootstrap.utils.IOUtils;
import pl.skmedix.bootstrap.utils.OSUtils;

public class Bootstrap {
    private static Bootstrap instance;
    private IUserInterface userInterface;
    private boolean forceUpdate;
    private String[] remainderArgs;
    private Path workingDirectory;
    private Path launcherDirectory;
    private Path librariesDirectory;
    private Path launcherJar;
    private Path launcherData;
    private ExecutorService downloadExecutor;
    private ScheduledExecutorService scheduledExecutor;
    private ExecutorService ioExecutor;
    private volatile boolean shutdownInProgress = false;
    private volatile CompletableFuture<Boolean> initializationFuture;
    private TaskContext taskContext;

    public Bootstrap(String[] args) {
        String[] properties;
        boolean isAsciiOnly;
        OptionSet optionSet;
        instance = this;
        SwingUserInterface.setLookAndFeel();
        this.initializeExecutors();
        OptionParser optionParser = new OptionParser();
        optionParser.allowsUnrecognizedOptions();
        optionParser.accepts("help", "Show help").forHelp();
        optionParser.accepts("force", "Force updating");
        ArgumentAcceptingOptionSpec<File> workingDirectoryOption = optionParser.accepts("workDir", "Optional").withRequiredArg().ofType(File.class).defaultsTo(OSUtils.getWorkingDirectory(), (File[])new File[0]);
        NonOptionArgumentSpec<String> nonOptions = optionParser.nonOptions();
        try {
            try {
                optionSet = optionParser.parse(args);
            }
            catch (OptionException e) {
                optionParser.printHelpOn(System.out);
                System.out.println("(to pass in arguments to minecraft directly use: '--' followed by your arguments");
                return;
            }
            if (optionSet.has("help")) {
                optionParser.printHelpOn(System.out);
                return;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        if (OSUtils.getOS() == OSUtils.OS.WIN && !(isAsciiOnly = System.getProperty("user.name", "User").chars().allMatch(c -> c < 128))) {
            Log.warn("[!] Your username in Windows contains only ASCII characters, your name should contain non-ASCII characters.\nThis may cause problems with starting the game or even the launcher!");
            AlertUtils.displayWarning("Warning", "Your username in Windows contains non-ASCII characters, your name should contain only letters and numbers.\nThis may cause problems with starting the game or even the launcher!");
        }
        try {
            File bootstrapJar = new File(Bootstrap.class.getProtectionDomain().getCodeSource().getLocation().toURI());
            if (bootstrapJar.getAbsolutePath().contains("!" + File.separator)) {
                Log.warn("Due to java limitation, please do not run this jar in a folder ending with !");
                Log.warn(bootstrapJar.getAbsolutePath());
                AlertUtils.displayWarning("Warning", "Due to java limitation, please do not run this jar in a folder ending with !\n" + bootstrapJar.getAbsolutePath());
                return;
            }
        }
        catch (URISyntaxException e) {
            Log.error("Failed to get bootstrap jar path", e);
        }
        this.workingDirectory = optionSet.valueOf(workingDirectoryOption).toPath();
        try {
            Files.createDirectories(this.workingDirectory, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new Error("Unable to create working directory: " + this.workingDirectory, e);
        }
        if (!Files.isDirectory(this.workingDirectory, new LinkOption[0])) {
            throw new Error("Invalid working directory (not a directory): " + this.workingDirectory);
        }
        this.forceUpdate = optionSet.has("force");
        List<String> strings = optionSet.valuesOf(nonOptions);
        this.remainderArgs = strings.toArray(new String[0]);
        this.launcherDirectory = this.workingDirectory.resolve("sklauncher");
        this.launcherJar = this.workingDirectory.resolve("sklauncher-fx.jar");
        this.launcherData = this.launcherDirectory.resolve("sklauncher_data.bin");
        try {
            Files.createDirectories(this.launcherDirectory, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new Error("Unable to create launcher directory: " + this.launcherDirectory, e);
        }
        if (!Files.isDirectory(this.launcherDirectory, new LinkOption[0])) {
            throw new Error("Invalid launcher directory (not a directory): " + this.launcherDirectory);
        }
        this.librariesDirectory = this.launcherDirectory.resolve("javafx");
        try {
            Files.createDirectories(this.librariesDirectory, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new Error("Unable to create libraries directory: " + this.librariesDirectory, e);
        }
        if (!Files.isDirectory(this.librariesDirectory, new LinkOption[0])) {
            throw new Error("Invalid libraries directory (not a directory): " + this.librariesDirectory);
        }
        Path launcherLog = this.launcherDirectory.resolve("sklauncher_logs.txt");
        Log.setLogFile(launcherLog.toFile());
        this.userInterface = this.selectUserInterface();
        this.userInterface.initializeFrame();
        Log.println("SKlauncher " + BootstrapConstants.getVersionName());
        Log.println(DateFormat.getDateTimeInstance(2, 2, Locale.GERMAN).format(new Date()));
        for (String property : properties = new String[]{"os.name", "os.version", "os.arch", "java.version", "java.vendor", "sun.arch.data.model"}) {
            Log.println("System.getProperty('" + property + "') == '" + System.getProperty(property) + "'");
        }
        this.readVMOptions();
        this.initialize();
    }

    public static Bootstrap getCurrentInstance() {
        return instance;
    }

    private void readVMOptions() {
        Path launcherVMOptions = this.launcherDirectory.resolve("sklauncher.vmoptions");
        if (!Files.exists(launcherVMOptions, new LinkOption[0]) || !Files.isRegularFile(launcherVMOptions, new LinkOption[0])) {
            this.extractVMOptions(launcherVMOptions);
        }
        Log.println("Reading VM options from " + launcherVMOptions);
        try (Stream<String> stream = Files.lines(launcherVMOptions);){
            stream.filter(line -> line.contains("=")).forEach(line -> {
                String[] vmOptionSplit = line.split("=");
                System.setProperty(vmOptionSplit[0], vmOptionSplit[1]);
                Log.println("System.setProperty('" + vmOptionSplit[0] + "', '" + vmOptionSplit[1] + "')");
            });
        }
        catch (IOException e) {
            AlertUtils.displayException("Error", e);
            try {
                Files.deleteIfExists(launcherVMOptions);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void initialize() {
        this.taskContext = new TaskContext(this.workingDirectory, this.launcherDirectory, this.librariesDirectory, this.launcherJar, this.launcherData, this.userInterface, this.downloadExecutor, this.ioExecutor, this.forceUpdate);
        TaskExecutor executor = new TaskExecutor(this.taskContext);
        executor.addTask(new CleanupTask()).addTask(new MirrorDiscoveryTask()).addTask(new ConfigurationTask()).addTask(new VersionCheckTask()).addTask(new FileValidationTask()).addTask(new ConditionalTask("needsUpdate", new TaskExecutor(this.taskContext).addTask(new PatchTask()).addTask(new FileUpdateTask()).addTask(new DependencyTask())));
        this.initializationFuture = executor.executeAsync().whenComplete((success, throwable) -> {
            if (success != null && success.booleanValue()) {
                Log.println("Bootstrap tasks completed, starting launcher...");
                Thread launcherThread = new Thread(() -> {
                    try {
                        LauncherStartTask launcherStartTask = new LauncherStartTask(this.remainderArgs);
                        TaskResult result = launcherStartTask.execute(this.taskContext);
                        if (result.isSuccess()) {
                            Log.println("Launcher started successfully");
                            Thread.sleep(5000L);
                            this.shutdownExecutor();
                        } else {
                            Log.println("Launcher start failed: " + result.getMessage());
                            if (result.getException() != null) {
                                AlertUtils.displayException("Failed to start launcher", result.getMessage(), result.getException());
                            } else {
                                AlertUtils.displayError("Failed to start launcher", result.getMessage());
                            }
                            System.exit(1);
                        }
                    }
                    catch (Exception e) {
                        if (!this.shutdownInProgress) {
                            AlertUtils.displayException("Fatal error", e);
                            System.exit(1);
                        }
                        this.shutdownExecutor();
                    }
                }, "SKL-Launcher-Starter");
                launcherThread.setDaemon(false);
                launcherThread.start();
            } else if (throwable != null && !this.shutdownInProgress) {
                AlertUtils.displayException("Fatal error", "Bootstrap initialization failed", (Exception)throwable);
                System.exit(1);
            } else if (success != null && !success.booleanValue()) {
                System.exit(1);
            }
        });
    }

    public void cancelInitialization() {
        this.shutdownInProgress = true;
        if (this.taskContext != null) {
            this.taskContext.cancel();
        }
        if (this.initializationFuture != null) {
            this.initializationFuture.cancel(true);
        }
        this.shutdownExecutor();
    }

    private void extractVMOptions(Path targetFile) {
        try (InputStream input = Bootstrap.class.getResourceAsStream("/sklauncher.vmoptions");
             OutputStream output = Files.newOutputStream(targetFile, new OpenOption[0]);){
            IOUtils.copy(input, output);
        }
        catch (IOException e) {
            AlertUtils.displayException("Fatal error", "Updater failed to extract VM options", e);
        }
    }

    private IUserInterface selectUserInterface() {
        return new SwingUserInterface();
    }

    public Path getWorkingDirectory() {
        return this.workingDirectory;
    }

    public Path getLauncherDirectory() {
        return this.launcherDirectory;
    }

    public Path getLibrariesDirectory() {
        return this.librariesDirectory;
    }

    public IUserInterface getUserInterface() {
        return this.userInterface;
    }

    private void initializeExecutors() {
        int coreCount = Runtime.getRuntime().availableProcessors();
        int downloadThreads = Math.max(4, Math.min(coreCount * 2, 8));
        this.downloadExecutor = Executors.newFixedThreadPool(downloadThreads, r -> {
            Thread t = new Thread(r, "SKL-Download-" + System.currentTimeMillis());
            t.setDaemon(true);
            t.setPriority(6);
            return t;
        });
        this.scheduledExecutor = Executors.newScheduledThreadPool(2, r -> {
            Thread t = new Thread(r, "SKL-Scheduled-" + System.currentTimeMillis());
            t.setDaemon(true);
            return t;
        });
        int ioThreads = Math.max(2, coreCount / 2);
        this.ioExecutor = Executors.newFixedThreadPool(ioThreads, r -> {
            Thread t = new Thread(r, "SKL-IO-" + System.currentTimeMillis());
            t.setDaemon(true);
            return t;
        });
    }

    private void shutdownExecutor() {
        this.shutdownInProgress = true;
        this.shutdownExecutorService(this.downloadExecutor, "Download");
        this.shutdownExecutorService(this.scheduledExecutor, "Scheduled");
        this.shutdownExecutorService(this.ioExecutor, "IO");
    }

    private void shutdownExecutorService(ExecutorService executor, String name) {
        if (executor != null && !executor.isShutdown()) {
            Log.println("Shutting down " + name + " executor...");
            executor.shutdown();
            try {
                if (!executor.awaitTermination(10L, TimeUnit.SECONDS)) {
                    Log.println("Force shutting down " + name + " executor...");
                    executor.shutdownNow();
                    if (!executor.awaitTermination(5L, TimeUnit.SECONDS)) {
                        Log.println("Could not terminate " + name + " executor");
                    }
                }
            }
            catch (InterruptedException e) {
                executor.shutdownNow();
                Thread.currentThread().interrupt();
            }
        }
    }
}

