/*
 * Decompiled with CFR 0.152.
 */
package pl.skmedix.bootstrap;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import org.jetbrains.annotations.NotNull;
import pl.skmedix.bootstrap.utils.StringUtils;

public class Log {
    private static PrintStream consoleOutput = System.out;

    public static void println(String string) {
        Log.printer("[SKL Updater] " + string);
    }

    public static void info(String string) {
        Log.println(string);
    }

    public static void warn(String string) {
        Log.printer("[SKL Updater] [WARN] " + string);
    }

    public static void error(String string) {
        Log.printer("[SKL Updater] [ERROR] " + string);
    }

    public static void error(String string, Throwable ex) {
        Log.printer("[SKL Updater] [ERROR] " + string);
        Log.printer("[SKL Updater] [ERROR] " + StringUtils.getStackTrace(ex));
    }

    public static void debug(String string) {
    }

    private static void printer(String line) {
        consoleOutput.println(line);
    }

    public static void setLogFile(File file) {
        try {
            consoleOutput = new DualStream(System.out, new PrintStream(new BufferedOutputStream(new FileOutputStream(file))));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        System.setOut(consoleOutput);
    }

    public static class DualStream
    extends PrintStream {
        public final PrintStream consoleOutput;
        public final PrintStream fileOutput;

        public DualStream(PrintStream consoleOutput, PrintStream fileOutput) {
            super(fileOutput, true);
            this.consoleOutput = consoleOutput;
            this.fileOutput = fileOutput;
        }

        @Override
        public void println() {
            this.consoleOutput.println();
            super.println();
        }

        @Override
        public void println(Object output) {
            this.consoleOutput.println(output);
            super.println(output);
        }

        @Override
        public void println(String output) {
            this.consoleOutput.println(output);
            super.println(output);
        }

        @Override
        public PrintStream printf(@NotNull String output, Object ... variables) {
            this.consoleOutput.printf(output, variables);
            super.printf(output, variables);
            return this;
        }
    }
}

