/*
 * Decompiled with CFR 0.152.
 */
package pl.skmedix.bootstrap;

import java.awt.GraphicsEnvironment;
import javax.swing.JEditorPane;
import javax.swing.JOptionPane;
import pl.skmedix.bootstrap.Bootstrap;
import pl.skmedix.bootstrap.SwingUserInterface;
import pl.skmedix.bootstrap.ui.swing.AlertUtils;
import pl.skmedix.bootstrap.utils.JavaVersion;

public class Main {
    public static void main(String[] args) {
        int javaVersion;
        if (GraphicsEnvironment.isHeadless()) {
            System.err.println("This application cannot run in headless mode.");
            System.exit(1);
        }
        if ((javaVersion = JavaVersion.get()) == 8 || javaVersion >= 17) {
            new Bootstrap(args);
            return;
        }
        Main.initError(javaVersion);
    }

    private static void initError(int javaVersion) {
        SwingUserInterface.setLookAndFeel();
        String style = "<style>p {font-family: Arial; font-size:14;} </style>";
        String err = String.format("<p>Your Java version (%s) <b>is not supported</b> with this version of launcher!</p>", javaVersion) + "<p>Please make sure that you meet one of the following requirements:<br> 1. Update to Java 25 <i>(SKlauncher will automatically download JavaFX)</i><br> 2. Use a JDK that bundles JavaFX</p>";
        System.out.println("Your Java version (" + javaVersion + ") is not supported with this version of launcher!");
        JEditorPane pane = new JEditorPane("text/html", style + err);
        pane.setEditable(false);
        pane.setOpaque(false);
        JOptionPane.showMessageDialog(AlertUtils.createModalFrame(), pane, "SKlauncher Fatal Error", 0);
        System.exit(1);
    }
}

