/*
 * Decompiled with CFR 0.152.
 */
package pl.skmedix.bootstrap;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.RoundRectangle2D;
import java.util.concurrent.TimeUnit;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import pl.skmedix.bootstrap.Bootstrap;
import pl.skmedix.bootstrap.BootstrapConstants;
import pl.skmedix.bootstrap.IUserInterface;
import pl.skmedix.bootstrap.ui.swing.LookAndFeel;
import pl.skmedix.bootstrap.ui.swing.SwingController;
import pl.skmedix.bootstrap.ui.swing.SwingHelper;
import pl.skmedix.bootstrap.utils.Utils;

public class SwingUserInterface
implements IUserInterface {
    private final JFrame frame;
    private SwingController controller;
    private Point dragOffset;

    public SwingUserInterface() {
        SwingUserInterface.setLookAndFeel();
        this.frame = new JFrame();
    }

    public static void setLookAndFeel() {
        LookAndFeel.setup();
    }

    @Override
    public void initializeFrame() {
        this.frame.getContentPane().removeAll();
        this.frame.setTitle("SKlauncher " + BootstrapConstants.getVersion().getNormalVersion());
        this.frame.setPreferredSize(new Dimension(340, 400));
        this.frame.setResizable(false);
        this.frame.setUndecorated(true);
        this.frame.setBackground(new Color(0, 0, 0, 0));
        this.frame.setDefaultCloseOperation(3);
        SwingHelper.setFrameIcon(this.frame, Bootstrap.class, "/favicon.png");
        this.controller = new SwingController();
        this.setupDragSupport();
        SwingUtilities.invokeLater(() -> {
            this.frame.add(this.controller);
            this.frame.pack();
            this.frame.setLocationRelativeTo(null);
            try {
                this.frame.setShape(new RoundRectangle2D.Float(0.0f, 0.0f, this.frame.getWidth(), this.frame.getHeight(), 24.0f, 24.0f));
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
            this.frame.setVisible(true);
            this.frame.setAlwaysOnTop(true);
            this.frame.setAlwaysOnTop(false);
        });
    }

    private void setupDragSupport() {
        MouseAdapter dragAdapter = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                SwingUserInterface.this.dragOffset = e.getPoint();
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                Point current = e.getLocationOnScreen();
                SwingUserInterface.this.frame.setLocation(current.x - ((SwingUserInterface)SwingUserInterface.this).dragOffset.x, current.y - ((SwingUserInterface)SwingUserInterface.this).dragOffset.y);
            }
        };
        this.controller.addMouseListener(dragAdapter);
        this.controller.addMouseMotionListener(dragAdapter);
    }

    @Override
    public void hideFrame() {
        Utils.sleep(1L, TimeUnit.SECONDS);
        if (this.controller != null) {
            this.controller.dispose();
        }
        this.frame.setVisible(false);
        this.frame.dispose();
    }

    @Override
    public SwingController getController() {
        return this.controller;
    }

    public JFrame getFrame() {
        return this.frame;
    }
}

