/*
 * Decompiled with CFR 0.152.
 */
package pl.skmedix.bootstrap.downloader;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.BindException;
import java.net.Proxy;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.concurrent.CountDownLatch;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLHandshakeException;
import pl.skmedix.bootstrap.Bootstrap;
import pl.skmedix.bootstrap.Log;
import pl.skmedix.bootstrap.ui.IController;
import pl.skmedix.bootstrap.ui.swing.AlertUtils;
import pl.skmedix.bootstrap.utils.URLUtils;

public class Downloader
implements Runnable {
    private static final int MAX_RETRIES = 10;
    private static final int INITIAL_RETRY_DELAY_MS = 1000;
    private static final int BUFFER_SIZE = 262144;
    private static final int PROGRESS_UPDATE_THRESHOLD = 5;
    private final IController uiController;
    private final Path destination;
    private URL url;
    private Controller controller;

    public Downloader(URL url, Path destination) {
        this.uiController = Bootstrap.getCurrentInstance().getUserInterface().getController();
        this.url = url;
        this.destination = destination;
    }

    public Downloader(IController controller, URL url, Path destination) {
        this.uiController = controller;
        this.url = url;
        this.destination = destination;
    }

    public Downloader(IController uiController, URL url, Path destination, Controller controller) {
        this.uiController = uiController;
        this.url = url;
        this.destination = destination;
        this.controller = controller;
    }

    public static void suggestHelp(Throwable t) {
        if (t instanceof BindException) {
            Log.println("Recognized exception: the likely cause is a broken ipv4/6 stack. Check your TCP/IP settings.");
            AlertUtils.displayException("Recognized exception", "The likely cause is a broken ipv4/6 stack. Check your TCP/IP settings.", (Exception)t);
        } else if (t instanceof SSLHandshakeException) {
            Log.println("Recognized exception: the likely cause is a set of broken/missing root-certificates. Check your java install and perhaps reinstall it.");
            AlertUtils.displayException("Recognized exception", "The likely cause is a set of broken/missing root-certificates. Check your java install and perhaps reinstall it.", (Exception)t);
        }
    }

    @Override
    public void run() {
        int retries = 0;
        int retryDelay = 1000;
        block19: while (++retries <= 10) {
            try {
                HttpsURLConnection connection = this.getConnection(this.url);
                connection.setUseCaches(false);
                connection.setDefaultUseCaches(false);
                connection.setRequestProperty("Cache-Control", "no-store,max-age=0,no-cache");
                connection.setRequestProperty("Expires", "0");
                connection.setRequestProperty("Pragma", "no-cache");
                connection.setRequestProperty("Connection", "keep-alive");
                connection.setConnectTimeout(30000);
                connection.setReadTimeout(30000);
                connection.setInstanceFollowRedirects(true);
                Log.println("Downloading '" + this.destination.getFileName() + "'... " + (retries > 1 ? String.format(" (try %d/%d)", retries, 10) : ""));
                long start = System.nanoTime();
                connection.connect();
                long elapsed = System.nanoTime() - start;
                Log.println("Got reply in: " + elapsed / 1000000L + "ms");
                boolean redirect = false;
                int code = connection.getResponseCode();
                if (code == 302 || code == 301 || code == 303) {
                    redirect = true;
                }
                if (redirect) {
                    this.url = URLUtils.constantURL(connection.getHeaderField("Location"));
                    --retries;
                    continue;
                }
                switch (code /= 100) {
                    case 2: {
                        this.uiController.startProgress();
                        long startDownload = System.nanoTime();
                        long bytesRead = 0L;
                        long contentLength = connection.getContentLengthLong();
                        byte[] buffer = new byte[262144];
                        int lastProgressPercent = -1;
                        try (InputStream inputStream = connection.getInputStream();
                             OutputStream outputStream = Files.newOutputStream(this.destination, new OpenOption[0]);){
                            int read;
                            while ((read = inputStream.read(buffer)) != -1) {
                                int currentPercent;
                                outputStream.write(buffer, 0, read);
                                if (contentLength <= 0L || (currentPercent = (int)((bytesRead += (long)read) * 100L / contentLength)) < lastProgressPercent + 5) continue;
                                this.uiController.setProgress((double)bytesRead / (double)contentLength);
                                lastProgressPercent = currentPercent;
                            }
                        }
                        long elapsedDownload = System.nanoTime() - startDownload;
                        float elapsedSeconds = (float)elapsedDownload / 1.0E9f;
                        float mbRead = (float)bytesRead / 1048576.0f;
                        this.uiController.endProgress();
                        if (this.controller != null) {
                            this.controller.hasDownloadedLatch.countDown();
                        }
                        Log.println(String.format("Downloaded %.2fMB in %.2fs at %.2fMB/s", Float.valueOf(mbRead), Float.valueOf(elapsedSeconds), Float.valueOf(mbRead / Math.max(elapsedSeconds, 0.001f))));
                        return;
                    }
                    case 4: {
                        Log.println("Remote file not found.");
                        return;
                    }
                    case 5: {
                        Log.println("Server error, retrying...");
                        continue block19;
                    }
                }
                Log.println("Unexpected response code: " + connection.getResponseCode());
            }
            catch (Exception e) {
                Log.println("Download attempt " + retries + " failed: " + e.getMessage());
                if (retries < 10) {
                    try {
                        Log.println("Waiting " + retryDelay + "ms before retry...");
                        Thread.sleep(retryDelay);
                        retryDelay = Math.min(retryDelay * 2, 30000);
                        continue;
                    }
                    catch (InterruptedException ie) {
                        Thread.currentThread().interrupt();
                        return;
                    }
                }
                Downloader.suggestHelp(e);
            }
        }
        Log.println("Unable to download remote file after 10 attempts. Check your internet connection/proxy settings.");
    }

    public HttpsURLConnection getConnection(URL url) throws IOException {
        return (HttpsURLConnection)url.openConnection(Proxy.NO_PROXY);
    }

    public static class Controller {
        public final CountDownLatch hasDownloadedLatch = new CountDownLatch(1);
    }
}

