/*
 * Decompiled with CFR 0.152.
 */
package pl.skmedix.bootstrap.task;

import com.skmedix.bootstrap.internal.json.JSONObject;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import pl.skmedix.bootstrap.IUserInterface;

public class TaskContext {
    private final Path workingDirectory;
    private final Path launcherDirectory;
    private final Path librariesDirectory;
    private final Path launcherJar;
    private final Path launcherData;
    private final IUserInterface userInterface;
    private final ExecutorService downloadExecutor;
    private final ExecutorService ioExecutor;
    private final boolean forceUpdate;
    private final Map<String, Object> data;
    private volatile boolean cancelled;
    private JSONObject configData;
    private String lastWorkingMirror;
    private String lastWorkingConfigHost;

    public TaskContext(Path workingDirectory, Path launcherDirectory, Path librariesDirectory, Path launcherJar, Path launcherData, IUserInterface userInterface, ExecutorService downloadExecutor, ExecutorService ioExecutor, boolean forceUpdate) {
        this.workingDirectory = workingDirectory;
        this.launcherDirectory = launcherDirectory;
        this.librariesDirectory = librariesDirectory;
        this.launcherJar = launcherJar;
        this.launcherData = launcherData;
        this.userInterface = userInterface;
        this.downloadExecutor = downloadExecutor;
        this.ioExecutor = ioExecutor;
        this.forceUpdate = forceUpdate;
        this.data = new HashMap<String, Object>();
        this.cancelled = false;
    }

    public Path getWorkingDirectory() {
        return this.workingDirectory;
    }

    public Path getLauncherDirectory() {
        return this.launcherDirectory;
    }

    public Path getLibrariesDirectory() {
        return this.librariesDirectory;
    }

    public Path getLauncherJar() {
        return this.launcherJar;
    }

    public Path getLauncherData() {
        return this.launcherData;
    }

    public IUserInterface getUserInterface() {
        return this.userInterface;
    }

    public ExecutorService getDownloadExecutor() {
        return this.downloadExecutor;
    }

    public ExecutorService getIoExecutor() {
        return this.ioExecutor;
    }

    public boolean isForceUpdate() {
        return this.forceUpdate;
    }

    public JSONObject getConfigData() {
        return this.configData;
    }

    public void setConfigData(JSONObject configData) {
        this.configData = configData;
    }

    public String getLastWorkingMirror() {
        return this.lastWorkingMirror;
    }

    public void setLastWorkingMirror(String lastWorkingMirror) {
        this.lastWorkingMirror = lastWorkingMirror;
    }

    public String getLastWorkingConfigHost() {
        return this.lastWorkingConfigHost;
    }

    public void setLastWorkingConfigHost(String lastWorkingConfigHost) {
        this.lastWorkingConfigHost = lastWorkingConfigHost;
    }

    public void put(String key, Object value) {
        this.data.put(key, value);
    }

    public <T> Optional<T> get(String key) {
        return Optional.ofNullable(this.data.get(key));
    }

    public void cancel() {
        this.cancelled = true;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public void checkCancellation() throws InterruptedException {
        if (this.cancelled || Thread.currentThread().isInterrupted()) {
            throw new InterruptedException("Operation cancelled");
        }
    }
}

