/*
 * Decompiled with CFR 0.152.
 */
package pl.skmedix.bootstrap.task;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import pl.skmedix.bootstrap.Log;
import pl.skmedix.bootstrap.task.Task;
import pl.skmedix.bootstrap.task.TaskContext;
import pl.skmedix.bootstrap.task.TaskResult;
import pl.skmedix.bootstrap.ui.swing.AlertUtils;

public class TaskExecutor {
    private final TaskContext context;
    private final List<Task> tasks;
    private double totalWeight;
    private double completedWeight;

    public TaskExecutor(TaskContext context) {
        this.context = context;
        this.tasks = new ArrayList<Task>();
        this.totalWeight = 0.0;
        this.completedWeight = 0.0;
    }

    public TaskExecutor addTask(Task task) {
        this.tasks.add(task);
        this.totalWeight += task.getWeight();
        return this;
    }

    public CompletableFuture<Boolean> executeAsync() {
        return CompletableFuture.supplyAsync(() -> {
            try {
                return this.execute();
            }
            catch (Exception e) {
                Log.error("Task execution failed", e);
                AlertUtils.displayException("Fatal error", "Bootstrap task execution failed", e);
                return false;
            }
        }, this.context.getIoExecutor());
    }

    public boolean execute() {
        this.context.getUserInterface().getController().startProgress();
        for (Task task : this.tasks) {
            try {
                this.context.checkCancellation();
                Log.println("Executing task: " + task.getName());
                this.updateProgress(task.getName(), this.completedWeight / this.totalWeight);
                TaskResult result = task.execute(this.context);
                if (!result.isSuccess()) {
                    Log.error("Task failed: " + task.getName() + " - " + result.getMessage());
                    if (result.getException() != null) {
                        AlertUtils.displayException("Task failed: " + task.getName(), result.getMessage(), result.getException());
                    } else {
                        AlertUtils.displayError("Task failed: " + task.getName(), result.getMessage());
                    }
                    return false;
                }
                this.completedWeight += task.getWeight();
                this.updateProgress("Completed: " + task.getName(), this.completedWeight / this.totalWeight);
                if (result.getMessage() == null) continue;
                Log.println("Task completed: " + task.getName() + " - " + result.getMessage());
            }
            catch (InterruptedException e) {
                Log.println("Task execution cancelled: " + task.getName());
                Thread.currentThread().interrupt();
                return false;
            }
            catch (Exception e) {
                Log.error("Task execution error: " + task.getName(), e);
                AlertUtils.displayException("Task failed: " + task.getName(), e);
                return false;
            }
        }
        this.updateProgress("All tasks completed", 1.0);
        this.context.getUserInterface().getController().endProgress();
        return true;
    }

    private void updateProgress(String status, double progress) {
        if (!this.context.isCancelled()) {
            this.context.getUserInterface().getController().setProgressStatus(status);
            this.context.getUserInterface().getController().setProgress(progress);
        }
    }
}

