/*
 * Decompiled with CFR 0.152.
 */
package pl.skmedix.bootstrap.task.impl;

import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import pl.skmedix.bootstrap.Log;
import pl.skmedix.bootstrap.task.Task;
import pl.skmedix.bootstrap.task.TaskContext;
import pl.skmedix.bootstrap.task.TaskResult;

public class CleanupTask
implements Task {
    @Override
    public String getName() {
        return "Cleanup";
    }

    @Override
    public TaskResult execute(TaskContext context) {
        DirectoryStream<Path> stream2;
        Path workingDirectory = context.getWorkingDirectory();
        Path launcherDirectory = context.getLauncherDirectory();
        Path[] oldFiles = new Path[]{workingDirectory.resolve("sklauncher.jar"), launcherDirectory.resolve("launcher.jar"), launcherDirectory.resolve("launcher.pack"), launcherDirectory.resolve("launcher.pack.lzma"), launcherDirectory.resolve("launcher.bps"), launcherDirectory.resolve("_IF_YOU_WANT_REINSTALL_LAUNCHER__DELETE_FILES_BELOW"), launcherDirectory.resolve("sklauncher.log"), launcherDirectory.resolve("sklauncher.data")};
        int deletedCount = 0;
        for (Path file : oldFiles) {
            try {
                if (!Files.deleteIfExists(file)) continue;
                ++deletedCount;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            stream2 = Files.newDirectoryStream(workingDirectory, "*.tmp");
            try {
                for (Path file : stream2) {
                    try {
                        if (!Files.deleteIfExists(file)) continue;
                        ++deletedCount;
                    }
                    catch (Exception exception) {}
                }
            }
            finally {
                if (stream2 != null) {
                    stream2.close();
                }
            }
        }
        catch (Exception stream2) {
            // empty catch block
        }
        try {
            stream2 = Files.newDirectoryStream(launcherDirectory, "patch-*.bin");
            try {
                for (Path file : stream2) {
                    try {
                        if (!Files.deleteIfExists(file)) continue;
                        ++deletedCount;
                    }
                    catch (Exception exception) {}
                }
            }
            finally {
                if (stream2 != null) {
                    stream2.close();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (deletedCount > 0) {
            Log.println("Cleaned up " + deletedCount + " legacy files");
        }
        return TaskResult.success("Cleaned up " + deletedCount + " files");
    }

    @Override
    public double getWeight() {
        return 0.5;
    }
}

