/*
 * Decompiled with CFR 0.152.
 */
package pl.skmedix.bootstrap.task.impl;

import pl.skmedix.bootstrap.Log;
import pl.skmedix.bootstrap.task.Task;
import pl.skmedix.bootstrap.task.TaskContext;
import pl.skmedix.bootstrap.task.TaskExecutor;
import pl.skmedix.bootstrap.task.TaskResult;

public class ConditionalTask
implements Task {
    private final String conditionKey;
    private final TaskExecutor conditionalExecutor;

    public ConditionalTask(String conditionKey, TaskExecutor conditionalExecutor) {
        this.conditionKey = conditionKey;
        this.conditionalExecutor = conditionalExecutor;
    }

    @Override
    public String getName() {
        return "Conditional: " + this.conditionKey;
    }

    @Override
    public TaskResult execute(TaskContext context) {
        boolean condition;
        Boolean conditionObj = context.get(this.conditionKey).orElse(false);
        boolean bl = condition = conditionObj instanceof Boolean ? conditionObj : false;
        if (condition) {
            Log.println("Condition '" + this.conditionKey + "' is true, executing conditional tasks");
            boolean success = this.conditionalExecutor.execute();
            return success ? TaskResult.success("Conditional tasks completed") : TaskResult.failure("Conditional tasks failed");
        }
        Log.println("Condition '" + this.conditionKey + "' is false, skipping conditional tasks");
        return TaskResult.success("Conditional tasks skipped");
    }

    @Override
    public double getWeight() {
        return 0.1;
    }
}

