/*
 * Decompiled with CFR 0.152.
 */
package pl.skmedix.bootstrap.task.impl;

import com.skmedix.bootstrap.internal.json.JSONObject;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileTime;
import java.util.Base64;
import java.util.Date;
import java.util.Optional;
import pl.skmedix.bootstrap.Log;
import pl.skmedix.bootstrap.task.Task;
import pl.skmedix.bootstrap.task.TaskContext;
import pl.skmedix.bootstrap.task.TaskResult;
import pl.skmedix.bootstrap.ui.swing.AlertUtils;
import pl.skmedix.bootstrap.utils.StringUtils;
import pl.skmedix.bootstrap.utils.URLUtils;
import pl.skmedix.bootstrap.utils.Utils;

public class ConfigurationTask
implements Task {
    @Override
    public String getName() {
        return "Configuration";
    }

    @Override
    public TaskResult execute(TaskContext context) {
        Optional mirrorUrl = context.get("mirrorUrl");
        if (mirrorUrl.isPresent()) {
            return this.saveLocalCache(context, (URL)mirrorUrl.get()) ? TaskResult.success("Configuration loaded from remote") : TaskResult.failure("Failed to read remote configuration");
        }
        return this.readLocalCache(context) ? TaskResult.success("Configuration loaded from cache") : TaskResult.failure("No valid configuration available");
    }

    private boolean saveLocalCache(TaskContext context, URL url) {
        Optional<JSONObject> optional = URLUtils.getJSONFromURL(url);
        if (!optional.isPresent()) {
            Log.println("Failed to read remote configuration");
            return false;
        }
        JSONObject jsonObject = optional.get();
        if (!jsonObject.has("timestamp")) {
            jsonObject.put("timestamp", new Date().getTime() / 1000L);
        }
        if (context.getLastWorkingMirror() != null) {
            jsonObject.put("lastWorkingMirror", context.getLastWorkingMirror());
            jsonObject.put("mirrorCacheTime", new Date().getTime() / 1000L);
        }
        if (context.getLastWorkingConfigHost() != null) {
            jsonObject.put("lastWorkingConfigHost", context.getLastWorkingConfigHost());
        }
        context.setConfigData(jsonObject);
        byte[] encoded = Base64.getMimeEncoder().encode(StringUtils.getBytes(jsonObject.toString()));
        try {
            Log.println("Saving local cache...");
            Path launcherData = context.getLauncherData();
            Utils.createRawFile(launcherData.toFile());
            Files.write(launcherData, StringUtils.reverseBytes(encoded), new OpenOption[0]);
            return true;
        }
        catch (Exception e) {
            Log.println("Failed to save local cache");
            AlertUtils.displayException("Fatal error", e);
            e.printStackTrace();
            try {
                Files.deleteIfExists(context.getLauncherData());
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return false;
        }
    }

    private boolean readLocalCache(TaskContext context) {
        Path launcherData = context.getLauncherData();
        try {
            if (!Files.exists(launcherData, new LinkOption[0]) || Files.size(launcherData) <= 0L) {
                Log.println("Server is offline, and local cached data is not valid");
                return false;
            }
            FileTime lastModified = Files.getLastModifiedTime(launcherData, new LinkOption[0]);
            if (new Date().getTime() - lastModified.toMillis() > 1209600000L) {
                Log.println("Local cached data is too old, deleting");
                Files.deleteIfExists(launcherData);
                return false;
            }
        }
        catch (IOException e) {
            return false;
        }
        try {
            byte[] bytesDecoded = Base64.getMimeDecoder().decode(StringUtils.reverseBytes(Files.readAllBytes(launcherData)));
            String data = StringUtils.getString(bytesDecoded);
            if (Utils.isJSONValid(data)) {
                JSONObject jsonData = new JSONObject(data);
                if (jsonData.has("timestamp") && new Date().getTime() / 1000L - jsonData.getLong("timestamp") > 1209600000L) {
                    Log.println("Local cached data is too old, deleting...");
                    Files.deleteIfExists(launcherData);
                    return false;
                }
                if (jsonData.has("lastWorkingMirror") && jsonData.has("mirrorCacheTime")) {
                    long cacheAge = new Date().getTime() / 1000L - jsonData.getLong("mirrorCacheTime");
                    if (cacheAge < 86400L) {
                        context.setLastWorkingMirror(jsonData.getString("lastWorkingMirror"));
                        Log.println("Loaded cached mirror: " + context.getLastWorkingMirror() + " (age: " + cacheAge / 3600L + "h)");
                        if (jsonData.has("lastWorkingConfigHost")) {
                            context.setLastWorkingConfigHost(jsonData.getString("lastWorkingConfigHost"));
                            Log.println("Loaded cached config host: " + context.getLastWorkingConfigHost());
                        }
                    } else {
                        Log.println("Cached mirror is too old (" + cacheAge / 3600L + "h), ignoring");
                    }
                }
                context.setConfigData(jsonData);
                return true;
            }
            Log.println("Local cached data is not valid, deleting...");
            Files.deleteIfExists(launcherData);
        }
        catch (IOException | IllegalArgumentException e) {
            Log.println("Local cached data error");
            AlertUtils.displayException("Error", "Local cached data is not valid, deleting...", e);
            e.printStackTrace();
            try {
                Files.deleteIfExists(launcherData);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return false;
    }

    @Override
    public double getWeight() {
        return 1.0;
    }
}

