/*
 * Decompiled with CFR 0.152.
 */
package pl.skmedix.bootstrap.task.impl;

import com.skmedix.bootstrap.internal.json.JSONObject;
import com.skmedix.bootstrap.internal.xz.XZInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import pl.skmedix.bootstrap.Log;
import pl.skmedix.bootstrap.downloader.Downloader;
import pl.skmedix.bootstrap.task.Task;
import pl.skmedix.bootstrap.task.TaskContext;
import pl.skmedix.bootstrap.task.TaskResult;
import pl.skmedix.bootstrap.ui.swing.AlertUtils;
import pl.skmedix.bootstrap.utils.Checksum;
import pl.skmedix.bootstrap.utils.IOUtils;
import pl.skmedix.bootstrap.utils.StringUtils;
import pl.skmedix.bootstrap.utils.URLUtils;

public class FileUpdateTask
implements Task {
    @Override
    public String getName() {
        return "File Update";
    }

    @Override
    public TaskResult execute(TaskContext context) {
        JSONObject rawObject;
        JSONObject downloadsObject;
        JSONObject configData = context.getConfigData();
        JSONObject filesObject = configData.getJSONObject("files");
        ArrayList<Future<Boolean>> downloadFutures = new ArrayList<Future<Boolean>>();
        ArrayList<String> filesToUpdate = new ArrayList<String>();
        for (String key : filesObject.keySet()) {
            JSONObject jSONObject = filesObject.getJSONObject(key);
            if (!jSONObject.has("downloads")) {
                Log.println("File " + key + " is not downloadable, skipping");
                continue;
            }
            downloadsObject = jSONObject.getJSONObject("downloads");
            rawObject = downloadsObject.getJSONObject("raw");
            Path localFile = context.getWorkingDirectory().resolve(key);
            if (Checksum.equals(localFile, rawObject.getString("sha1"))) {
                Log.println("File " + key + " is up to date");
                continue;
            }
            filesToUpdate.add(key);
        }
        for (String key : filesToUpdate) {
            JSONObject jSONObject = filesObject.getJSONObject(key);
            downloadsObject = jSONObject.getJSONObject("downloads");
            rawObject = downloadsObject.getJSONObject("raw");
            boolean isCompressed = downloadsObject.has("lzma");
            JSONObject lzmaObject = isCompressed ? downloadsObject.getJSONObject("lzma") : null;
            Future<Boolean> future = context.getDownloadExecutor().submit(() -> {
                try {
                    String expectedHash;
                    Path localFile = context.getWorkingDirectory().resolve(key);
                    String mirrorHost = context.getLastWorkingMirror();
                    if (mirrorHost != null && mirrorHost.contains("/")) {
                        mirrorHost = mirrorHost.substring(0, mirrorHost.lastIndexOf(47));
                    }
                    JSONObject downloadObj = isCompressed ? lzmaObject : rawObject;
                    String path = downloadObj.getString("path");
                    String host = downloadObj.optString("host", mirrorHost);
                    String remoteUrl = host + path;
                    Path targetFile = isCompressed ? context.getLauncherDirectory().resolve(key + ".xz") : localFile;
                    new Downloader(context.getUserInterface().getController(), URLUtils.constantURL(remoteUrl), targetFile).run();
                    String string = expectedHash = isCompressed ? lzmaObject.getString("sha1") : rawObject.getString("sha1");
                    if (!Checksum.equals(targetFile, expectedHash)) {
                        Log.println("Provided hash for " + key + " is INVALID");
                        Files.deleteIfExists(targetFile);
                        return false;
                    }
                    if (isCompressed && !this.unpackFile(targetFile, localFile)) {
                        return false;
                    }
                    if (!Checksum.equals(localFile, rawObject.getString("sha1"))) {
                        Log.println("Provided hash for decompressed " + key + " is INVALID");
                        Files.deleteIfExists(localFile);
                        if (isCompressed) {
                            Files.deleteIfExists(targetFile);
                        }
                        return false;
                    }
                    Log.println("File " + key + " updated successfully");
                    if (isCompressed) {
                        Files.deleteIfExists(targetFile);
                    }
                    return true;
                }
                catch (Exception e) {
                    Log.error("Failed to update file " + key, e);
                    return false;
                }
            });
            downloadFutures.add(future);
        }
        boolean allSuccessful = true;
        for (Future future : downloadFutures) {
            try {
                if (((Boolean)future.get()).booleanValue()) continue;
                allSuccessful = false;
            }
            catch (InterruptedException | ExecutionException e) {
                Log.error("Download task failed", e);
                allSuccessful = false;
            }
        }
        if (!allSuccessful) {
            AlertUtils.displayError("Critical Error", "Some files failed to download or verify");
            return TaskResult.failure("Some files failed to download");
        }
        return TaskResult.success("All files updated successfully");
    }

    private boolean unpackFile(Path packedFile, Path output) {
        Log.println("Unpacking " + packedFile.getFileName() + "...");
        try (OutputStream out = Files.newOutputStream(output, new OpenOption[0]);
             XZInputStream xzIn = new XZInputStream(Files.newInputStream(packedFile, new OpenOption[0]));){
            IOUtils.copy((InputStream)xzIn, out);
        }
        catch (IOException e) {
            AlertUtils.displayException("Fatal error", "Failed to unpack launcher files", e);
            Log.println("Failed to unpack '" + packedFile.getFileName() + "' to '" + output.getFileName() + "'\n" + StringUtils.getStackTrace(e));
            try {
                Files.deleteIfExists(packedFile);
                Files.deleteIfExists(output);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return false;
        }
        try {
            Files.deleteIfExists(packedFile);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Log.println("Successfully unpacked file '" + packedFile.getFileName() + "' to '" + output.getFileName() + "'");
        return true;
    }

    @Override
    public double getWeight() {
        return 3.0;
    }
}

