/*
 * Decompiled with CFR 0.152.
 */
package pl.skmedix.bootstrap.task.impl;

import com.skmedix.bootstrap.internal.json.JSONObject;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import pl.skmedix.bootstrap.Log;
import pl.skmedix.bootstrap.task.Task;
import pl.skmedix.bootstrap.task.TaskContext;
import pl.skmedix.bootstrap.task.TaskResult;
import pl.skmedix.bootstrap.utils.Checksum;
import pl.skmedix.bootstrap.utils.JavaVersion;
import pl.skmedix.bootstrap.utils.OSUtils;
import pl.skmedix.bootstrap.utils.fx.JFXInjection;
import pl.skmedix.bootstrap.utils.fx.RuntimeProperties;

public class FileValidationTask
implements Task {
    @Override
    public String getName() {
        return "File Validation";
    }

    @Override
    public TaskResult execute(TaskContext context) {
        JSONObject configData = context.getConfigData();
        boolean isExecutableUpToDate = false;
        if (configData.has("files")) {
            JSONObject filesObject = configData.getJSONObject("files");
            for (String key : filesObject.keySet()) {
                JSONObject fileObject = filesObject.getJSONObject(key);
                if (!fileObject.has("downloads")) {
                    Log.println("File " + key + " is not downloadable, skipping");
                    continue;
                }
                JSONObject downloadsObject = fileObject.getJSONObject("downloads");
                JSONObject rawObject = downloadsObject.getJSONObject("raw");
                Path localFile = context.getWorkingDirectory().resolve(key);
                if (!Files.exists(localFile, new LinkOption[0])) {
                    Log.println("File " + key + " is missing");
                    isExecutableUpToDate = false;
                    break;
                }
                if (Checksum.equals(localFile, rawObject.getString("sha1"))) {
                    Log.println("File " + key + " is up to date");
                    isExecutableUpToDate = true;
                    continue;
                }
                Log.println("File " + key + " is outdated");
                isExecutableUpToDate = false;
                break;
            }
        }
        if (JavaVersion.get() >= 9 && configData.has("javafx")) {
            JSONObject javafxObject = configData.getJSONObject("javafx");
            String jfxUrl = javafxObject.getString("maven");
            String jfxVersion = javafxObject.getString("version");
            if (OSUtils.getOS() == OSUtils.OS.MACOS && RuntimeProperties.OS_VERSION.startsWith("10.") || OSUtils.getOS() == OSUtils.OS.WIN && !OSUtils.isWindows64Bit()) {
                jfxVersion = "19.0.2.1";
            }
            List<Object> jfxModules = javafxObject.getJSONArray("modules").toList();
            JFXInjection.buildDependencyUrlsList(jfxUrl, jfxVersion, jfxModules);
            boolean areLocalDependenciesValid = JFXInjection.areLocalDependenciesValid();
            Log.println("JFX dependencies are " + (areLocalDependenciesValid ? "valid" : "invalid"));
            boolean needsUpdate = context.isForceUpdate() || !isExecutableUpToDate || !areLocalDependenciesValid;
            context.put("needsUpdate", needsUpdate);
            return TaskResult.success(needsUpdate ? "Updates required" : "All files are up to date");
        }
        boolean needsUpdate = context.isForceUpdate() || !isExecutableUpToDate;
        context.put("needsUpdate", needsUpdate);
        Log.println("Executable is " + (isExecutableUpToDate ? "up to date" : "outdated"));
        return TaskResult.success(needsUpdate ? "Updates required" : "All files are up to date");
    }

    @Override
    public double getWeight() {
        return 1.0;
    }
}

