/*
 * Decompiled with CFR 0.152.
 */
package pl.skmedix.bootstrap.task.impl;

import com.skmedix.bootstrap.internal.semver.Version;
import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import pl.skmedix.bootstrap.BootstrapConstants;
import pl.skmedix.bootstrap.Log;
import pl.skmedix.bootstrap.task.Task;
import pl.skmedix.bootstrap.task.TaskContext;
import pl.skmedix.bootstrap.task.TaskResult;
import pl.skmedix.bootstrap.ui.swing.AlertUtils;
import pl.skmedix.bootstrap.utils.StringUtils;
import pl.skmedix.bootstrap.utils.fx.AccessPatcher;
import pl.skmedix.bootstrap.utils.fx.JFXInjection;

public class LauncherStartTask
implements Task {
    private final String[] remainderArgs;

    public LauncherStartTask(String[] remainderArgs) {
        this.remainderArgs = remainderArgs;
    }

    @Override
    public String getName() {
        return "Launcher Start";
    }

    @Override
    public TaskResult execute(TaskContext context) {
        Path launcherJar = context.getLauncherJar();
        if (!Files.exists(launcherJar, new LinkOption[0])) {
            return TaskResult.failure("Launcher JAR does not exist");
        }
        try {
            Log.println("Starting launcher initialization...");
            long startTime = System.currentTimeMillis();
            AccessPatcher.patch();
            JFXInjection.ensureJavafxSupport();
            Log.println("JavaFX support ensured in " + (System.currentTimeMillis() - startTime) + "ms");
            URLClassLoader classLoader = new URLClassLoader(new URL[]{launcherJar.toUri().toURL()});
            Class<?> launcher = classLoader.loadClass("net.minecraft.launcher.Launcher");
            Constructor<?> constructor = launcher.getConstructor(File.class, Proxy.class, PasswordAuthentication.class, String[].class, Integer.class, Boolean.TYPE);
            Log.println("Launcher class loaded, invoking constructor...");
            Version version = BootstrapConstants.getVersion();
            constructor.newInstance(context.getWorkingDirectory().toFile(), Proxy.NO_PROXY, null, this.remainderArgs, Integer.valueOf(String.format("%d%d%d", version.majorVersion(), version.minorVersion(), version.patchVersion())), false);
            Log.println("Launcher constructor completed in " + (System.currentTimeMillis() - startTime) + "ms");
            this.logActiveThreads();
            context.getUserInterface().hideFrame();
            Log.println("Launcher started successfully, bootstrap UI hidden");
            return TaskResult.success("Launcher started");
        }
        catch (InvocationTargetException e) {
            AlertUtils.displayRawException("Fatal error", StringUtils.getStackTrace(e));
            return TaskResult.failure("Launcher invocation failed", e);
        }
        catch (Exception | NoClassDefFoundError e) {
            return TaskResult.failure("Unable to start launcher: " + e.getMessage(), (Exception)e);
        }
    }

    private void logActiveThreads() {
        Log.println("Active thread count: " + Thread.activeCount());
        for (Thread t : Thread.getAllStackTraces().keySet()) {
            if (t.isDaemon()) continue;
            Log.println("Non-daemon thread: " + t.getName() + " (state: " + (Object)((Object)t.getState()) + ")");
        }
    }

    @Override
    public double getWeight() {
        return 0.5;
    }
}

