/*
 * Decompiled with CFR 0.152.
 */
package pl.skmedix.bootstrap.task.impl;

import com.skmedix.bootstrap.internal.json.JSONObject;
import java.net.URL;
import java.util.Optional;
import pl.skmedix.bootstrap.BootstrapConstants;
import pl.skmedix.bootstrap.Log;
import pl.skmedix.bootstrap.task.Task;
import pl.skmedix.bootstrap.task.TaskContext;
import pl.skmedix.bootstrap.task.TaskResult;
import pl.skmedix.bootstrap.utils.URLUtils;

public class MirrorDiscoveryTask
implements Task {
    @Override
    public String getName() {
        return "Mirror Discovery";
    }

    @Override
    public TaskResult execute(TaskContext context) throws Exception {
        String cachedMirror = context.getLastWorkingMirror();
        if (cachedMirror != null) {
            try {
                URL cachedUrl = URLUtils.constantURL(cachedMirror);
                Log.println("Trying cached mirror: " + cachedUrl.getHost());
                long startTime = System.nanoTime();
                Optional<URL> result = this.testMirror(cachedUrl, startTime, context);
                if (result.isPresent()) {
                    context.put("mirrorUrl", result.get());
                    return TaskResult.success("Using cached mirror: " + cachedUrl.getHost());
                }
                Log.println("Cached mirror failed, trying others...");
                context.setLastWorkingMirror(null);
            }
            catch (Exception e) {
                Log.error("Cached mirror failed: " + e.getMessage());
                context.setLastWorkingMirror(null);
            }
        }
        for (URL url : BootstrapConstants.getMirrorList()) {
            if (url.toString().equals(cachedMirror)) continue;
            try {
                Log.println("Testing mirror: " + url.getHost());
                long startTime = System.nanoTime();
                Optional<URL> result = this.testMirror(url, startTime, context);
                if (!result.isPresent()) continue;
                context.setLastWorkingMirror(url.toString());
                context.put("mirrorUrl", result.get());
                return TaskResult.success("Found working mirror: " + url.getHost());
            }
            catch (Exception e) {
                Log.error("Mirror " + url.getHost() + " failed: " + e.getMessage());
            }
        }
        Log.println("No valid mirror found, will try local cache");
        return TaskResult.success("No mirror available, falling back to cache");
    }

    private Optional<URL> testMirror(URL url, long startTime, TaskContext context) throws Exception {
        JSONObject jsonObject = URLUtils.getJSONFromURL(url, false).orElse(null);
        if (jsonObject != null && jsonObject.has("servers")) {
            URL configUrl;
            String server;
            JSONObject servers = jsonObject.getJSONObject("servers");
            String cachedConfigHost = context.getLastWorkingConfigHost();
            if (cachedConfigHost != null) {
                for (String key : servers.keySet()) {
                    server = servers.getString(key);
                    if (!server.endsWith(".json") || !(configUrl = URLUtils.constantURL(server)).getHost().equals(cachedConfigHost)) continue;
                    if (URLUtils.testConnection(configUrl)) {
                        long responseTime = System.nanoTime() - startTime;
                        Log.println("Using cached config: " + configUrl.getHost() + " (response time: " + responseTime / 1000000L + "ms)");
                        return Optional.of(configUrl);
                    }
                    Log.println("Cached config host " + cachedConfigHost + " not responding, trying others...");
                    context.setLastWorkingConfigHost(null);
                    break;
                }
            }
            for (String key : servers.keySet()) {
                server = servers.getString(key);
                if (!server.endsWith(".json")) continue;
                configUrl = URLUtils.constantURL(server);
                if (URLUtils.testConnection(configUrl)) {
                    long responseTime = System.nanoTime() - startTime;
                    Log.println("Using config: " + configUrl.getHost() + " (response time: " + responseTime / 1000000L + "ms)");
                    context.setLastWorkingConfigHost(configUrl.getHost());
                    return Optional.of(configUrl);
                }
                Log.println("Config URL " + configUrl.getHost() + " not responding, trying next...");
            }
        } else {
            Log.println("Mirror " + url.getHost() + " returned invalid data");
        }
        return Optional.empty();
    }

    @Override
    public double getWeight() {
        return 1.5;
    }
}

