/*
 * Decompiled with CFR 0.152.
 */
package pl.skmedix.bootstrap.task.impl;

import com.skmedix.bootstrap.internal.jbeat.Patcher;
import com.skmedix.bootstrap.internal.json.JSONObject;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import pl.skmedix.bootstrap.Log;
import pl.skmedix.bootstrap.downloader.Downloader;
import pl.skmedix.bootstrap.task.Task;
import pl.skmedix.bootstrap.task.TaskContext;
import pl.skmedix.bootstrap.task.TaskResult;
import pl.skmedix.bootstrap.ui.swing.AlertUtils;
import pl.skmedix.bootstrap.utils.Checksum;
import pl.skmedix.bootstrap.utils.RandomString;
import pl.skmedix.bootstrap.utils.URLUtils;

public class PatchTask
implements Task {
    @Override
    public String getName() {
        return "Patch";
    }

    @Override
    public TaskResult execute(TaskContext context) throws Exception {
        Path launcherJar = context.getLauncherJar();
        if (!Files.exists(launcherJar, new LinkOption[0])) {
            Log.println("Launcher jar is missing, skipping patching");
            return TaskResult.success("No patching needed");
        }
        JSONObject configData = context.getConfigData();
        if (!configData.has("patches")) {
            Log.println("No patches to apply");
            return TaskResult.success("No patches available");
        }
        JSONObject patchesObject = configData.getJSONObject("patches");
        String checksum = Checksum.sha1(launcherJar);
        int patchCount = 0;
        while (patchesObject.has(checksum)) {
            Log.println("Patching launcher with " + checksum);
            JSONObject patchObject = patchesObject.getJSONObject(checksum);
            if (patchObject.has("algo") && patchObject.getInt("algo") != 0) {
                Log.println("Unsupported patch algorithm, skipping patching");
                break;
            }
            String mirrorHost = context.getLastWorkingMirror();
            if (mirrorHost != null && mirrorHost.contains("/")) {
                mirrorHost = mirrorHost.substring(0, mirrorHost.lastIndexOf(47));
            }
            String path = patchObject.getString("path");
            String host = patchObject.optString("host", mirrorHost);
            String patchUrl = host + path;
            Path patchFile = context.getLauncherDirectory().resolve(String.format("patch-%s.bin", checksum));
            try {
                Files.deleteIfExists(patchFile);
            }
            catch (Exception exception) {
                // empty catch block
            }
            Downloader.Controller controller = new Downloader.Controller();
            Thread thread = new Thread(new Downloader(context.getUserInterface().getController(), URLUtils.constantURL(patchUrl), patchFile, controller));
            thread.start();
            try {
                controller.hasDownloadedLatch.await();
            }
            catch (InterruptedException e) {
                return TaskResult.failure("Failed to download patch", e);
            }
            if (!this.patchLauncher(launcherJar, patchFile)) {
                return TaskResult.failure("Failed to apply patch");
            }
            patchesObject.remove(checksum);
            checksum = Checksum.sha1(launcherJar);
            Log.println("Launcher patched, new checksum is '" + checksum + "'");
            ++patchCount;
        }
        if (patchCount == 0) {
            Log.println("No patches to apply");
            return TaskResult.success("No patches needed");
        }
        return TaskResult.success("Applied " + patchCount + " patch(es)");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean patchLauncher(Path file, Path patchFile) {
        String suffix = "." + RandomString.getAlphaNumericString(6) + ".tmp";
        Path sourceTemp = file.getParent().resolve(file.getFileName() + ".src" + suffix);
        Path targetTemp = file.getParent().resolve(file.getFileName() + ".patched" + suffix);
        try {
            Files.copy(file, sourceTemp, StandardCopyOption.REPLACE_EXISTING);
            Log.println("Patching launcher...");
            new Patcher(patchFile, sourceTemp, targetTemp).patch();
            Files.move(targetTemp, file, StandardCopyOption.REPLACE_EXISTING);
            Log.println("Successfully patched launcher");
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            Log.error("Failed to patch launcher", e);
            AlertUtils.displayException("Fatal error", "Failed to patch launcher", e);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                Files.deleteIfExists(sourceTemp);
                Files.deleteIfExists(targetTemp);
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public double getWeight() {
        return 2.0;
    }
}

