/*
 * Decompiled with CFR 0.152.
 */
package pl.skmedix.bootstrap.task.impl;

import com.skmedix.bootstrap.internal.json.JSONObject;
import com.skmedix.bootstrap.internal.semver.Version;
import pl.skmedix.bootstrap.BootstrapConstants;
import pl.skmedix.bootstrap.Log;
import pl.skmedix.bootstrap.task.Task;
import pl.skmedix.bootstrap.task.TaskContext;
import pl.skmedix.bootstrap.task.TaskResult;
import pl.skmedix.bootstrap.ui.swing.AlertUtils;
import pl.skmedix.bootstrap.utils.OSUtils;
import pl.skmedix.bootstrap.utils.URLUtils;

public class VersionCheckTask
implements Task {
    @Override
    public String getName() {
        return "Version Check";
    }

    @Override
    public TaskResult execute(TaskContext context) {
        JSONObject configData = context.getConfigData();
        if (!configData.has("format") || configData.getInt("format") != 2 || !configData.has("version")) {
            AlertUtils.displayError("Error", "Failed to read version manifest. Please restart or update the launcher.");
            return TaskResult.failure("Invalid version manifest");
        }
        Version remoteVersion = Version.valueOf(configData.getString("version"));
        if (BootstrapConstants.getVersion().lessThan(remoteVersion)) {
            if (configData.has("update")) {
                JSONObject update = configData.getJSONObject("update");
                AlertUtils.displayWarning(update.getString("title"), update.getString("header"));
                if (update.has("url")) {
                    OSUtils.openLink(URLUtils.constantURI(update.getString("url")));
                }
                Log.println("Update available, please update the bootstrap");
            } else {
                Log.println("Your bootstrap is probably outdated");
            }
            return TaskResult.failure("Bootstrap is outdated");
        }
        Log.println("Bootstrap is up to date");
        return TaskResult.success("Bootstrap version is current");
    }

    @Override
    public double getWeight() {
        return 0.5;
    }
}

