/*
 * Decompiled with CFR 0.152.
 */
package pl.skmedix.bootstrap.ui.swing;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.StringWriter;
import java.net.URI;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import pl.skmedix.bootstrap.utils.StringUtils;

public class AlertUtils {
    private static final String DISCORD_URL = "https://skmedix.pl/discord";

    public static void displayException(String title, @NotNull Exception ex) {
        AlertUtils.displayException(title, "Something went wrong when trying to load the launcher.", ex);
    }

    public static void displayException(String title, String content, @NotNull Exception ex) {
        AlertUtils.displayRawException(title, content, StringUtils.getStackTrace(ex));
    }

    public static void displayRawException(String title, @NotNull String ex) {
        AlertUtils.displayRawException(title, "Something went wrong when trying to load the launcher.", ex);
    }

    public static void displayRawException(String title, String content, @NotNull String ex) {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        toolkit.beep();
        StringWriter writer = new StringWriter();
        writer.append("OS: ").append(System.getProperty("os.name")).append("\n");
        writer.append("Architecture: ").append(System.getProperty("os.arch")).append("\n");
        writer.append("Version: ").append(System.getProperty("java.version")).append("\n");
        writer.append("Vendor: ").append(System.getProperty("java.vm.vendor")).append("\n\n");
        writer.append("Exception: ");
        writer.append(ex);
        String errorString = writer.toString();
        StringSelection selection = new StringSelection(errorString);
        Clipboard clipboard = toolkit.getSystemClipboard();
        clipboard.setContents(selection, selection);
        String message = content;
        AlertUtils.showErrorMessageWindow(toolkit, errorString, null, message);
    }

    public static void showErrorMessageWindow(Toolkit toolkit, String errorString, @Nullable String style, String message) {
        Color bgColor = UIManager.getColor("Panel.background");
        Color textPrimary = UIManager.getColor("Label.foreground");
        Color textSecondary = UIManager.getColor("Label.disabledForeground");
        Color codeBg = UIManager.getColor("ProgressBar.background");
        Color borderColor = new Color(2763317);
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        mainPanel.setBackground(bgColor);
        mainPanel.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        JLabel contentLabel = new JLabel("<html>" + message + "</html>");
        contentLabel.setFont(new Font("Inter", 0, 14));
        contentLabel.setForeground(textPrimary);
        contentLabel.setAlignmentX(0.0f);
        mainPanel.add(contentLabel);
        mainPanel.add(Box.createVerticalStrut(8));
        JLabel infoLabel = new JLabel("<html><b>The following information about the problem has been copied to your clipboard:</b></html>");
        infoLabel.setFont(new Font("Inter", 0, 14));
        infoLabel.setForeground(textPrimary);
        infoLabel.setAlignmentX(0.0f);
        mainPanel.add(infoLabel);
        mainPanel.add(Box.createVerticalStrut(12));
        JTextArea errorArea = new JTextArea(errorString);
        errorArea.setFont(new Font("Consolas", 0, 12));
        errorArea.setForeground(textSecondary);
        errorArea.setBackground(codeBg);
        errorArea.setEditable(false);
        errorArea.setLineWrap(false);
        errorArea.setBorder(BorderFactory.createEmptyBorder(12, 12, 12, 12));
        errorArea.setCaretPosition(0);
        JScrollPane errorScroll = new JScrollPane(errorArea);
        errorScroll.setBorder(BorderFactory.createLineBorder(borderColor, 1));
        errorScroll.setAlignmentX(0.0f);
        errorScroll.getViewport().setBackground(codeBg);
        int lineCount = StringUtils.countMatches(errorString, "\n") + 1;
        int errorHeight = Math.min(Math.max(lineCount * 16 + 24, 150), 350);
        errorScroll.setPreferredSize(new Dimension(650, errorHeight));
        errorScroll.setMaximumSize(new Dimension(Integer.MAX_VALUE, errorHeight));
        mainPanel.add(errorScroll);
        mainPanel.add(Box.createVerticalStrut(12));
        JLabel discordLabel = new JLabel("<html>If you believe this is a bug, please <a href=\"https://skmedix.pl/discord\" style=\"color: #4891FF;\">contact us on our Discord</a>.</html>");
        discordLabel.setFont(new Font("Inter", 0, 14));
        discordLabel.setForeground(textPrimary);
        discordLabel.setAlignmentX(0.0f);
        discordLabel.setCursor(new Cursor(12));
        discordLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                try {
                    Desktop.getDesktop().browse(new URI(AlertUtils.DISCORD_URL));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        mainPanel.add(discordLabel);
        JScrollPane mainScroll = new JScrollPane(mainPanel);
        mainScroll.setBorder(BorderFactory.createEmptyBorder());
        mainScroll.getViewport().setBackground(bgColor);
        mainScroll.setHorizontalScrollBarPolicy(31);
        int totalHeight = Math.min(errorHeight + 180, toolkit.getScreenSize().height - 200);
        mainScroll.setPreferredSize(new Dimension(700, totalHeight));
        SwingUtilities.invokeLater(() -> {
            JScrollBar vertical = mainScroll.getVerticalScrollBar();
            vertical.setValue(vertical.getMinimum());
        });
        JFrame frame = AlertUtils.createModalFrame();
        JOptionPane.showMessageDialog(frame, mainScroll, "SKlauncher Error", 0);
        frame.setLocationRelativeTo(null);
        frame.pack();
    }

    public static void displayMessage(String title, String header) {
        JFrame frame = AlertUtils.createModalFrame();
        JOptionPane.showMessageDialog(frame, header, title, 1);
        frame.pack();
        frame.setLocationRelativeTo(null);
    }

    public static void displayWarning(String title, String header) {
        JFrame frame = AlertUtils.createModalFrame();
        JOptionPane.showMessageDialog(frame, header, title, 2);
        frame.pack();
        frame.setLocationRelativeTo(null);
    }

    public static void displayError(String title, String header) {
        JFrame frame = AlertUtils.createModalFrame();
        JOptionPane.showMessageDialog(frame, header, title, 0);
        frame.pack();
        frame.setLocationRelativeTo(null);
    }

    public static JFrame createModalFrame() {
        JFrame frame = new JFrame();
        frame.setAlwaysOnTop(true);
        return frame;
    }
}

