/*
 * Decompiled with CFR 0.152.
 */
package pl.skmedix.bootstrap.ui.swing;

import com.formdev.flatlaf.FlatDarkLaf;
import java.awt.Color;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import javax.swing.UIManager;

public class LookAndFeel {
    private static final String[] LOOK_AND_FEEL_CLASSES = new String[]{"com.formdev.flatlaf.FlatDarkLaf", "com.formdev.flatlaf.FlatLaf"};
    private static final boolean IS_FLATLAF_AVAILABLE = LookAndFeel.isFlatLafAvailable();

    private static boolean isFlatLafAvailable() {
        for (String className : LOOK_AND_FEEL_CLASSES) {
            try {
                Class.forName(className);
                return true;
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
        }
        return false;
    }

    public static void setup() {
        System.setProperty("sun.java2d.opengl", "true");
        System.setProperty("awt.useSystemAAFontSettings", "on");
        System.setProperty("swing.aatext", "true");
        if (IS_FLATLAF_AVAILABLE) {
            FlatDarkLaf.setup();
        } else {
            try {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        LookAndFeel.applyTheme();
        LookAndFeel.setupFonts();
    }

    private static void applyTheme() {
        Color background = new Color(855311);
        Color foreground = new Color(0xE8E8EC);
        Color accent = new Color(11032055);
        Color disabledBg = new Color(0x1A1A22);
        Color disabledFg = new Color(9145236);
        Color cardBg = new Color(0x12121A);
        Color border = new Color(2763317);
        Color hoverBg = new Color(0x252532);
        Color hoverThumb = new Color(3816008);
        UIManager.put("Panel.background", background);
        UIManager.put("Label.foreground", foreground);
        UIManager.put("Label.disabledForeground", disabledFg);
        UIManager.put("ProgressBar.background", disabledBg);
        UIManager.put("ProgressBar.foreground", accent);
        UIManager.put("ProgressBar.selectionBackground", accent);
        UIManager.put("ProgressBar.selectionForeground", foreground);
        Color accentBlue = new Color(3900150);
        Color accentBlueHover = new Color(2450411);
        Color accentBluePressed = new Color(1920728);
        UIManager.put("Button.background", accentBlue);
        UIManager.put("Button.foreground", foreground);
        UIManager.put("Button.focusedBackground", accentBlueHover);
        UIManager.put("Button.hoverBackground", accentBlueHover);
        UIManager.put("Button.pressedBackground", accentBluePressed);
        UIManager.put("Button.focusedBorderColor", accentBlue);
        UIManager.put("Button.hoverBorderColor", accentBlueHover);
        UIManager.put("ScrollBar.track", cardBg);
        UIManager.put("ScrollBar.thumb", border);
        UIManager.put("ScrollBar.thumbInactive", disabledBg);
        UIManager.put("ScrollBar.hoverTrackColor", disabledBg);
        UIManager.put("ScrollBar.hoverThumbColor", hoverThumb);
        UIManager.put("Component.accentColor", accent);
        UIManager.put("Component.focusColor", accent);
        UIManager.put("OptionPane.background", background);
        UIManager.put("OptionPane.messageForeground", foreground);
        UIManager.put("OptionPane.warningDialog.titlePane.background", background);
        UIManager.put("OptionPane.errorDialog.titlePane.background", background);
        UIManager.put("OptionPane.questionDialog.titlePane.background", background);
        UIManager.put("TitlePane.background", background);
        UIManager.put("TitlePane.foreground", foreground);
        UIManager.put("TitlePane.inactiveBackground", background);
        UIManager.put("TitlePane.inactiveForeground", disabledFg);
        UIManager.put("RootPane.background", background);
    }

    private static void setupFonts() {
        try {
            GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
            String[] fonts = ge.getAvailableFontFamilyNames();
            String preferredFont = "Inter";
            boolean hasPreferred = false;
            for (String font : fonts) {
                if (!font.equals(preferredFont)) continue;
                hasPreferred = true;
                break;
            }
            String fontFamily = hasPreferred ? preferredFont : "SansSerif";
            Font baseFont = new Font(fontFamily, 0, 13);
            UIManager.put("defaultFont", baseFont);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

