/*
 * Decompiled with CFR 0.152.
 */
package pl.skmedix.bootstrap.ui.swing;

import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.Arc2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import pl.skmedix.bootstrap.Bootstrap;
import pl.skmedix.bootstrap.BootstrapConstants;
import pl.skmedix.bootstrap.ui.IController;
import pl.skmedix.bootstrap.ui.swing.SwingHelper;

public class SwingController
extends JPanel
implements IController {
    private static final Color BG_GRADIENT_START = new Color(0x12121A);
    private static final Color BG_GRADIENT_END = new Color(657933);
    private static final Color ACCENT_PURPLE = new Color(11032055);
    private static final Color ACCENT_BLUE = new Color(3900150);
    private static final Color TEXT_PRIMARY = new Color(0xE8E8EC);
    private static final Color TEXT_SECONDARY = new Color(9145236);
    private static final Color PROGRESS_BG = new Color(0x1A1A22);
    private static final Color BORDER_SUBTLE = new Color(2763317);
    private final JLabel statusLabel;
    private final ProgressRing progressRing;
    private final BufferedImage logo;
    private final BufferedImage scaledLogo;
    private float glowPulse = 0.0f;
    private Timer glowTimer;

    public SwingController() {
        this.setOpaque(false);
        this.setLayout(new BorderLayout());
        this.logo = SwingHelper.readBufferedImage(Bootstrap.class, "/logo.png");
        this.scaledLogo = SwingController.scaleLogoHighQuality(this.logo, 80, 80);
        this.progressRing = new ProgressRing();
        this.statusLabel = new JLabel("Initializing...");
        this.statusLabel.setFont(new Font("Inter", 0, 13));
        this.statusLabel.setForeground(TEXT_SECONDARY);
        this.statusLabel.setHorizontalAlignment(0);
        JPanel centerPanel = new JPanel(){

            @Override
            protected void paintComponent(Graphics g) {
            }
        };
        centerPanel.setOpaque(false);
        centerPanel.setLayout(new BoxLayout(centerPanel, 1));
        centerPanel.add(Box.createVerticalGlue());
        JPanel logoPanel = new JPanel(new FlowLayout(1, 0, 0));
        logoPanel.setOpaque(false);
        logoPanel.add(this.progressRing);
        centerPanel.add(logoPanel);
        centerPanel.add(Box.createVerticalStrut(24));
        JLabel titleLabel = new JLabel("SKlauncher");
        titleLabel.setFont(new Font("Inter", 1, 22));
        titleLabel.setForeground(TEXT_PRIMARY);
        titleLabel.setAlignmentX(0.5f);
        centerPanel.add(titleLabel);
        centerPanel.add(Box.createVerticalStrut(4));
        JLabel versionLabel = new JLabel("v" + BootstrapConstants.getVersion().getNormalVersion());
        versionLabel.setFont(new Font("Inter", 0, 12));
        versionLabel.setForeground(TEXT_SECONDARY);
        versionLabel.setAlignmentX(0.5f);
        centerPanel.add(versionLabel);
        centerPanel.add(Box.createVerticalGlue());
        this.add((Component)centerPanel, "Center");
        JPanel bottomPanel = new JPanel(new BorderLayout());
        bottomPanel.setOpaque(false);
        bottomPanel.setBorder(BorderFactory.createEmptyBorder(0, 32, 28, 32));
        bottomPanel.add((Component)this.statusLabel, "Center");
        this.add((Component)bottomPanel, "South");
        this.startGlowAnimation();
    }

    private void startGlowAnimation() {
        this.glowTimer = new Timer(40, e -> {
            this.glowPulse += 0.05f;
            if ((double)this.glowPulse > Math.PI * 2) {
                this.glowPulse = 0.0f;
            }
            this.progressRing.setGlowIntensity((float)(0.3 + 0.2 * Math.sin(this.glowPulse)));
            this.repaint();
        });
        this.glowTimer.start();
    }

    @Override
    protected void paintComponent(Graphics g) {
        Graphics2D g2d = (Graphics2D)g.create();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        int width = this.getWidth();
        int height = this.getHeight();
        GradientPaint bgGradient = new GradientPaint(0.0f, 0.0f, BG_GRADIENT_START, 0.0f, height, BG_GRADIENT_END);
        g2d.setPaint(bgGradient);
        g2d.fill(new RoundRectangle2D.Float(0.0f, 0.0f, width, height, 24.0f, 24.0f));
        g2d.setColor(BORDER_SUBTLE);
        g2d.setStroke(new BasicStroke(1.0f));
        g2d.draw(new RoundRectangle2D.Float(0.5f, 0.5f, width - 1, height - 1, 24.0f, 24.0f));
        this.paintSubtleGrid(g2d, width, height);
        g2d.dispose();
        super.paintComponent(g);
    }

    private void paintSubtleGrid(Graphics2D g2d, int width, int height) {
        g2d.setColor(new Color(0x1A1A22));
        int spacing = 30;
        for (int x = 0; x < width; x += spacing) {
            g2d.drawLine(x, 0, x, height);
        }
        for (int y = 0; y < height; y += spacing) {
            g2d.drawLine(0, y, width, y);
        }
    }

    @Override
    public void setProgressStatus(String status) {
        SwingUtilities.invokeLater(() -> this.statusLabel.setText(status));
    }

    @Override
    public void setProgress(double percent) {
        SwingUtilities.invokeLater(() -> {
            this.progressRing.setIndeterminate(false);
            this.progressRing.setProgress(percent);
        });
    }

    @Override
    public void startProgress() {
        SwingUtilities.invokeLater(() -> this.progressRing.setIndeterminate(true));
    }

    @Override
    public void endProgress() {
        SwingUtilities.invokeLater(() -> {
            this.progressRing.setIndeterminate(false);
            this.progressRing.setProgress(1.0);
        });
    }

    public void dispose() {
        if (this.glowTimer != null) {
            this.glowTimer.stop();
        }
        this.progressRing.dispose();
    }

    private static BufferedImage scaleLogoHighQuality(BufferedImage source, int targetWidth, int targetHeight) {
        if (source == null) {
            return null;
        }
        Image scaled = source.getScaledInstance(targetWidth, targetHeight, 16);
        BufferedImage result = new BufferedImage(targetWidth, targetHeight, 2);
        Graphics2D g2d = result.createGraphics();
        g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.drawImage(scaled, 0, 0, null);
        g2d.dispose();
        return result;
    }

    private class ProgressRing
    extends JComponent {
        private static final int SIZE = 140;
        private static final int RING_THICKNESS = 4;
        private static final int LOGO_SIZE = 80;
        private double progress = 0.0;
        private boolean indeterminate = true;
        private float glowIntensity = 0.3f;
        private float spinAngle = 0.0f;
        private Timer spinTimer;

        ProgressRing() {
            this.setPreferredSize(new Dimension(140, 140));
            this.setMinimumSize(new Dimension(140, 140));
            this.setMaximumSize(new Dimension(140, 140));
            this.spinTimer = new Timer(16, e -> {
                if (this.indeterminate) {
                    this.spinAngle += 3.0f;
                    if (this.spinAngle >= 360.0f) {
                        this.spinAngle = 0.0f;
                    }
                    this.repaint();
                }
            });
            this.spinTimer.start();
        }

        void setProgress(double progress) {
            this.progress = Math.max(0.0, Math.min(1.0, progress));
            this.repaint();
        }

        void setIndeterminate(boolean indeterminate) {
            this.indeterminate = indeterminate;
            this.repaint();
        }

        void setGlowIntensity(float intensity) {
            this.glowIntensity = intensity;
        }

        void dispose() {
            if (this.spinTimer != null) {
                this.spinTimer.stop();
            }
        }

        @Override
        protected void paintComponent(Graphics g) {
            Graphics2D g2d = (Graphics2D)g.create();
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2d.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
            g2d.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
            g2d.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
            int cx = this.getWidth() / 2;
            int cy = this.getHeight() / 2;
            int radius = 60;
            this.paintGlow(g2d, cx, cy, radius);
            g2d.setColor(PROGRESS_BG);
            g2d.setStroke(new BasicStroke(4.0f, 1, 1));
            g2d.drawOval(cx - radius, cy - radius, radius * 2, radius * 2);
            if (this.indeterminate) {
                this.drawGradientArc(g2d, cx, cy, radius, 90.0f - this.spinAngle, 90.0);
            } else {
                this.drawGradientArc(g2d, cx, cy, radius, 90.0, -(360.0 * this.progress));
            }
            if (SwingController.this.scaledLogo != null) {
                int logoX = cx - 40;
                int logoY = cy - 40;
                g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
                g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                g2d.drawImage((Image)SwingController.this.scaledLogo, logoX, logoY, null);
            }
            g2d.dispose();
        }

        private void paintGlow(Graphics2D g2d, int cx, int cy, int radius) {
            int midR = (ACCENT_PURPLE.getRed() + ACCENT_BLUE.getRed()) / 2;
            int midG = (ACCENT_PURPLE.getGreen() + ACCENT_BLUE.getGreen()) / 2;
            int midB = (ACCENT_PURPLE.getBlue() + ACCENT_BLUE.getBlue()) / 2;
            for (int i = 20; i > 0; i -= 4) {
                int alpha = (int)(this.glowIntensity * 100.0f) / (i / 2);
                g2d.setColor(new Color(midR, midG, midB, Math.min(255, alpha)));
                g2d.setStroke(new BasicStroke(4 + i));
                g2d.drawOval(cx - radius, cy - radius, radius * 2, radius * 2);
            }
        }

        private void drawGradientArc(Graphics2D g2d, int cx, int cy, int radius, double startAngle, double arcExtent) {
            if (Math.abs(arcExtent) < 0.1) {
                return;
            }
            int segments = Math.max(1, (int)Math.abs(arcExtent / 2.0));
            double segmentAngle = arcExtent / (double)segments;
            g2d.setStroke(new BasicStroke(4.0f, 1, 1));
            for (int i = 0; i < segments; ++i) {
                double t = (double)i / (double)Math.max(1, segments - 1);
                Color segmentColor = this.interpolateColor(ACCENT_PURPLE, ACCENT_BLUE, (float)t);
                g2d.setColor(segmentColor);
                double segStart = startAngle + (double)i * segmentAngle;
                Arc2D.Double arc = new Arc2D.Double(cx - radius, cy - radius, radius * 2, radius * 2, segStart, segmentAngle + 0.5, 0);
                g2d.draw(arc);
            }
        }

        private Color interpolateColor(Color c1, Color c2, float t) {
            t = Math.max(0.0f, Math.min(1.0f, t));
            int r = (int)((float)c1.getRed() + t * (float)(c2.getRed() - c1.getRed()));
            int g = (int)((float)c1.getGreen() + t * (float)(c2.getGreen() - c1.getGreen()));
            int b = (int)((float)c1.getBlue() + t * (float)(c2.getBlue() - c1.getBlue()));
            return new Color(r, g, b);
        }
    }
}

