/*
 * Decompiled with CFR 0.152.
 */
package pl.skmedix.bootstrap.utils;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Formatter;
import org.jetbrains.annotations.Nullable;
import pl.skmedix.bootstrap.Log;
import pl.skmedix.bootstrap.utils.StringUtils;

public class Checksum {
    public static boolean equals(File file, String hash) {
        return Checksum.equals(file != null ? file.toPath() : null, hash);
    }

    public static boolean equals(Path path, String hash) {
        if (path == null || !Files.exists(path, new LinkOption[0])) {
            Log.println("File '" + (path != null ? path.toAbsolutePath() : "null") + "' doesn't exist!");
            return false;
        }
        if (hash == null || hash.isEmpty()) {
            Log.println("Hash is null or empty!");
            return false;
        }
        String fileHash = Checksum.sha1(path);
        boolean equals = hash.equals(fileHash);
        Log.println("Checksum check: '" + (fileHash != null ? fileHash : "null") + (equals ? "' == '" : "' != '") + hash + "'?");
        return equals;
    }

    @Nullable
    public static String sha1(File file) {
        return Checksum.sha1(file.toPath());
    }

    @Nullable
    public static String sha1(Path path) {
        MessageDigest messageDigest = MessageDigest.getInstance("SHA1");
        try (BufferedInputStream is = new BufferedInputStream(Files.newInputStream(path, new OpenOption[0]));){
            int read;
            byte[] object = new byte[1024];
            while ((read = ((InputStream)is).read(object)) != -1) {
                messageDigest.update(object, 0, read);
            }
        }
        Formatter formatter = new Formatter();
        try {
            for (byte b : messageDigest.digest()) {
                formatter.format("%02x", b);
            }
            String string = formatter.toString();
            formatter.close();
            return string;
        }
        catch (Throwable throwable) {
            try {
                try {
                    formatter.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | NoSuchAlgorithmException e) {
                Log.println("Error while calculating SHA1 hash:\n" + StringUtils.getStackTrace(e));
                e.printStackTrace();
                return null;
            }
        }
    }
}

