/*
 * Decompiled with CFR 0.152.
 */
package pl.skmedix.bootstrap.utils;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.jetbrains.annotations.NotNull;

public class IOUtils {
    public static String toString(InputStream input) throws IOException {
        StringBuilderWriter sw = new StringBuilderWriter();
        IOUtils.copy(input, (Writer)sw);
        return sw.toString();
    }

    private static void copy(InputStream input, Writer output) throws IOException {
        InputStreamReader in = new InputStreamReader(input, StandardCharsets.UTF_8);
        IOUtils.copy(in, output);
    }

    private static int copy(Reader input, Writer output) throws IOException {
        long count = IOUtils.copyLarge(input, output);
        if (count > Integer.MAX_VALUE) {
            return -1;
        }
        return (int)count;
    }

    private static long copyLarge(Reader input, Writer output) throws IOException {
        return IOUtils.copyLarge(input, output, new char[4096]);
    }

    private static long copyLarge(@NotNull Reader input, Writer output, char[] buffer) throws IOException {
        int n;
        long count = 0L;
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
            count += (long)n;
        }
        return count;
    }

    public static int copy(InputStream inputStream, OutputStream outputStream) throws IOException {
        long count = IOUtils.copyLarge(inputStream, outputStream);
        if (count > Integer.MAX_VALUE) {
            return -1;
        }
        return (int)count;
    }

    public static long copyLarge(InputStream inputStream, OutputStream outputStream) throws IOException {
        return IOUtils.copy(inputStream, outputStream, 8192);
    }

    public static long copy(InputStream inputStream, OutputStream outputStream, int bufferSize) throws IOException {
        return IOUtils.copyLarge(inputStream, outputStream, IOUtils.byteArray(bufferSize));
    }

    public static long copyLarge(InputStream inputStream, OutputStream outputStream, byte[] buffer) throws IOException {
        int n;
        long count = 0L;
        while (-1 != (n = inputStream.read(buffer))) {
            outputStream.write(buffer, 0, n);
            count += (long)n;
        }
        return count;
    }

    public static byte[] byteArray(int size) {
        return new byte[size];
    }

    public static boolean isRegularFile(File file, LinkOption ... options) {
        return file != null && Files.isRegularFile(file.toPath(), options);
    }

    public static boolean isRegularFile(Path path) {
        return IOUtils.isOnDefaultFileSystem(path) ? path.toFile().isFile() : Files.isRegularFile(path, new LinkOption[0]);
    }

    public static boolean isOnDefaultFileSystem(Path path) {
        return path.getFileSystem() == FileSystems.getDefault();
    }

    public static class StringBuilderWriter
    extends Writer
    implements Serializable {
        private static final long serialVersionUID = -146927496096066153L;
        private final StringBuilder builder = new StringBuilder();

        @Override
        public Writer append(char value) {
            this.builder.append(value);
            return this;
        }

        @Override
        public Writer append(CharSequence value) {
            this.builder.append(value);
            return this;
        }

        @Override
        public Writer append(CharSequence value, int start, int end) {
            this.builder.append(value, start, end);
            return this;
        }

        @Override
        public void close() {
        }

        @Override
        public void flush() {
        }

        @Override
        public void write(@NotNull String value) {
            if (value != null) {
                this.builder.append(value);
            }
        }

        @Override
        public void write(char @NotNull [] value, int offset, int length) {
            if (value != null) {
                this.builder.append(value, offset, length);
            }
        }

        public String toString() {
            return this.builder.toString();
        }
    }
}

