/*
 * Decompiled with CFR 0.152.
 */
package pl.skmedix.bootstrap.utils;

import pl.skmedix.bootstrap.Log;

public class JavaVersion {
    public static final int VERSION_OFFSET = 44;
    private static final String JAVA_CLASS_VERSION = "java.class.version";
    private static final String JAVA_VM_SPEC_VERSION = "java.vm.specification.version";
    private static final int FALLBACK_VERSION = 8;
    private static int version = -1;

    public static int get() {
        if (version < 0) {
            String property = System.getProperty(JAVA_CLASS_VERSION, "");
            if (!property.isEmpty()) {
                version = (int)(Float.parseFloat(property) - 44.0f);
                return version;
            }
            Log.println(String.format("Property '%s' not found, using '%s' as fallback", JAVA_CLASS_VERSION, JAVA_VM_SPEC_VERSION));
            property = System.getProperty(JAVA_VM_SPEC_VERSION, "");
            if (property.contains(".")) {
                version = (int)Float.parseFloat(property.substring(property.indexOf(46) + 1));
                return version;
            }
            if (!property.isEmpty()) {
                version = Integer.parseInt(property);
                return version;
            }
            Log.println(String.format("Property '%s' not found, using '%s' as fallback", JAVA_VM_SPEC_VERSION, 8));
            return 8;
        }
        return version;
    }
}

