/*
 * Decompiled with CFR 0.152.
 */
package pl.skmedix.bootstrap.utils;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import pl.skmedix.bootstrap.Log;

public class OSUtils {
    private static final String[] linuxBrowsers = new String[]{"xdg-open", "google-chrome", "firefox", "microsoft-edge", "opera", "konqueror", "mozilla"};

    public static OS getOS() {
        String osName = System.getProperty("os.name").toLowerCase();
        if (osName.contains("win")) {
            return OS.WIN;
        }
        if (osName.contains("mac")) {
            return OS.MACOS;
        }
        return OS.UNIX;
    }

    public static File getWorkingDirectory() {
        File workDir;
        String workDirectory = "minecraft";
        String userHome = System.getProperty("user.home", ".");
        switch (OSUtils.getOS().ordinal()) {
            case 2: 
            case 3: {
                workDir = new File(userHome, "." + workDirectory + "/");
                break;
            }
            case 0: {
                String appData = System.getenv("APPDATA");
                workDir = new File(appData != null ? appData : userHome, "." + workDirectory + "/");
                break;
            }
            case 1: {
                workDir = new File(userHome, "Library/Application Support/" + workDirectory + "/");
                break;
            }
            default: {
                workDir = new File(userHome, "minecraft/");
            }
        }
        return workDir;
    }

    public static void openLink(URI link) {
        try {
            if (OSUtils.getOS() == OS.UNIX) {
                for (String browser : linuxBrowsers) {
                    try (InputStream is = Runtime.getRuntime().exec(new String[]{"which", browser}).getInputStream();){
                        if (is.read() != -1) {
                            Runtime.getRuntime().exec(new String[]{browser, link.toString()});
                            return;
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    Log.warn("Unable to open link: " + link + " (No browser found)");
                }
            }
            Class<?> desktopClass = Class.forName("java.awt.Desktop");
            Object o = desktopClass.getMethod("getDesktop", new Class[0]).invoke(null, new Object[0]);
            desktopClass.getMethod("browse", URI.class).invoke(o, link);
        }
        catch (Throwable e) {
            if (OSUtils.getOS() == OS.MACOS) {
                try {
                    Runtime.getRuntime().exec(new String[]{"/usr/bin/open", link.toString()});
                }
                catch (IOException e1) {
                    Log.error("Failed to open link " + link, e1);
                }
            }
            Log.error("Failed to open link " + link.toString(), e);
        }
    }

    public static boolean isWindows64Bit() {
        return System.getenv("ProgramFiles(x86)") != null;
    }

    public static enum OS {
        WIN,
        MACOS,
        SOLARIS,
        UNIX,
        UNKNOWN;

    }
}

