/*
 * Decompiled with CFR 0.152.
 */
package pl.skmedix.bootstrap.utils;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class StringUtils {
    public static int countMatches(@NotNull String text, String pattern) {
        int count = 0;
        while (text.contains(pattern)) {
            text = text.replaceFirst(pattern, "");
            ++count;
        }
        return count;
    }

    @NotNull
    public static String getStackTrace(@NotNull Throwable throwable) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter((Writer)sw, true);
        throwable.printStackTrace(pw);
        return sw.getBuffer().toString();
    }

    public static boolean notEmpty(String string) {
        return string != null && !string.isEmpty();
    }

    @Contract(value="null -> true", pure=true)
    public static boolean isEmpty(String string) {
        return string == null || string.isEmpty();
    }

    public static byte[] getBytes(String string) {
        return string.getBytes(StandardCharsets.UTF_8);
    }

    public static String getString(byte[] bytes) {
        return new String(bytes, StandardCharsets.UTF_8);
    }

    public static byte[] reverseBytes(byte[] bytes) {
        byte[] reversedBytes = new byte[bytes.length];
        for (int i = 0; i < bytes.length; ++i) {
            reversedBytes[i] = bytes[bytes.length - i - 1];
        }
        return reversedBytes;
    }
}

