/*
 * Decompiled with CFR 0.152.
 */
package pl.skmedix.bootstrap.utils;

import com.skmedix.bootstrap.internal.json.JSONObject;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Optional;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import pl.skmedix.bootstrap.Log;
import pl.skmedix.bootstrap.downloader.Downloader;
import pl.skmedix.bootstrap.ui.swing.AlertUtils;
import pl.skmedix.bootstrap.utils.IOUtils;

public class URLUtils {
    public static Optional<String> getStringFromURL(URL url, boolean showError) {
        Optional<String> optional;
        block9: {
            InputStream inputStream = URLUtils.makeConnection(url);
            try {
                optional = Optional.of(IOUtils.toString(inputStream));
                if (inputStream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    Log.error("Error while reading from URL", e);
                    if (showError) {
                        AlertUtils.displayException("Error while reading from URL", e);
                        Downloader.suggestHelp(e);
                    }
                    return Optional.empty();
                }
            }
            inputStream.close();
        }
        return optional;
    }

    public static Optional<JSONObject> getJSONFromURL(URL url) {
        return URLUtils.getStringFromURL(url, true).map(JSONObject::new);
    }

    public static Optional<JSONObject> getJSONFromURL(URL url, boolean showError) {
        return URLUtils.getStringFromURL(url, showError).map(JSONObject::new);
    }

    @Contract(value="_ -> new")
    @NotNull
    public static URI constantURI(String input) {
        try {
            return new URI(input);
        }
        catch (URISyntaxException e) {
            throw new Error(e);
        }
    }

    @Contract(value="_ -> new")
    @NotNull
    public static URL constantURL(String input) {
        try {
            return new URL(input);
        }
        catch (MalformedURLException e) {
            throw new Error(e);
        }
    }

    public static InputStream makeConnection(URL url) throws IOException {
        URLConnection conn = url.openConnection();
        conn.setConnectTimeout(15000);
        conn.setReadTimeout(60000);
        return conn.getInputStream();
    }

    public static boolean testConnection(URL url) {
        boolean bl;
        block8: {
            URLConnection conn = url.openConnection();
            conn.setConnectTimeout(5000);
            conn.setReadTimeout(5000);
            InputStream is = conn.getInputStream();
            try {
                boolean bl2 = bl = is.read() != -1;
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    return false;
                }
            }
            is.close();
        }
        return bl;
    }
}

