/*
 * Decompiled with CFR 0.152.
 */
package pl.skmedix.bootstrap.utils;

import com.skmedix.bootstrap.internal.json.JSONArray;
import com.skmedix.bootstrap.internal.json.JSONException;
import com.skmedix.bootstrap.internal.json.JSONObject;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import pl.skmedix.bootstrap.Log;

public class Utils {
    public static boolean isJSONValid(@NotNull String json) {
        try {
            new JSONObject(json);
        }
        catch (JSONException ex) {
            try {
                new JSONArray(json);
            }
            catch (JSONException ex1) {
                return false;
            }
        }
        return true;
    }

    public static void writeStringToFile(@NotNull File file, String string) throws IOException {
        List<String> lines = Collections.singletonList(string);
        Path path = Paths.get(file.toURI());
        Files.write(path, lines, StandardCharsets.UTF_8, new OpenOption[0]);
    }

    public static void createRawFile(@NotNull File destination) throws Exception {
        try {
            Files.createDirectories(destination.toPath().getParent(), new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new Exception("Unable to create directory", e);
        }
        try {
            Files.deleteIfExists(destination.toPath());
        }
        catch (IOException e) {
            throw new Exception("Couldn't delete previous files (" + destination.getName() + ") Make sure, another Launcher or Minecraft is not running", e);
        }
        try {
            Files.createFile(destination.toPath(), new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new Exception("Couldn't create the new file (" + destination.getName() + ") Make sure, another Launcher or Minecraft is not running", e);
        }
    }

    public static void deleteFile(Path file) {
        for (int tries = 0; tries < 10; ++tries) {
            try {
                Files.deleteIfExists(file);
                break;
            }
            catch (IOException ignored) {
                Log.error("Couldn't delete file: " + file.getFileName() + " (try " + tries + ")");
                Utils.sleep(5L * (long)tries, TimeUnit.SECONDS);
                continue;
            }
        }
    }

    public static boolean sleep(long time, TimeUnit unit) {
        try {
            unit.sleep(time);
        }
        catch (InterruptedException e) {
            return false;
        }
        return true;
    }
}

