/*
 * Decompiled with CFR 0.152.
 */
package pl.skmedix.bootstrap.utils.fx;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import pl.skmedix.bootstrap.Log;
import pl.skmedix.bootstrap.utils.JavaVersion;
import pl.skmedix.bootstrap.utils.fx.JigsawUtil;

public class AccessPatcher {
    private AccessPatcher() {
    }

    public static void patch() {
        int version = JavaVersion.get();
        if (version > 8) {
            try {
                Log.debug("Opening access to all packages");
                AccessPatcher.openPackages();
                Log.debug("Patching package reflection restrictions");
                AccessPatcher.patchReflectionFilters();
            }
            catch (Throwable t) {
                Log.error("Failed access patching on Java " + version, t);
            }
        }
    }

    private static void openPackages() {
        try {
            Method export = Module.class.getDeclaredMethod("implAddOpens", String.class);
            JigsawUtil.setMethodModifiers(export, 1);
            HashSet<Module> modules = new HashSet<Module>();
            Class<JigsawUtil> classBase = JigsawUtil.class;
            Module base = JigsawUtil.getClassModule(classBase);
            if (base.getLayer() != null) {
                modules.addAll(base.getLayer().modules());
            }
            modules.addAll(ModuleLayer.boot().modules());
            for (ClassLoader cl = classBase.getClassLoader(); cl != null; cl = cl.getParent()) {
                modules.add(JigsawUtil.getLoaderModule(cl));
            }
            for (Module module : modules) {
                for (String name : module.getPackages()) {
                    try {
                        export.invoke((Object)module, name);
                    }
                    catch (Exception ex) {
                        Log.error(String.format("Could not export package %s in module %s", name, module));
                        Log.error("Root cause: ", ex);
                    }
                }
            }
        }
        catch (Exception ex) {
            throw new IllegalStateException("Could not export packages", ex);
        }
    }

    private static void patchReflectionFilters() {
        Class<?> klass;
        try {
            klass = Class.forName("jdk.internal.reflect.Reflection", true, null);
        }
        catch (ClassNotFoundException ex) {
            throw new RuntimeException("Unable to locate 'jdk.internal.reflect.Reflection' class", ex);
        }
        try {
            Field[] fields;
            try {
                Method m = Class.class.getDeclaredMethod("getDeclaredFieldsImpl", new Class[0]);
                m.setAccessible(true);
                fields = (Field[])m.invoke(klass, new Object[0]);
            }
            catch (NoSuchMethodException | InvocationTargetException ex) {
                try {
                    Method m = Class.class.getDeclaredMethod("getDeclaredFields0", Boolean.TYPE);
                    m.setAccessible(true);
                    fields = (Field[])m.invoke(klass, false);
                }
                catch (NoSuchMethodException | InvocationTargetException ex1) {
                    ex.addSuppressed(ex1);
                    throw new RuntimeException("Unable to get all class fields", ex);
                }
            }
            int c = 0;
            for (Field field : fields) {
                String name = field.getName();
                if (!"fieldFilterMap".equals(name) && !"methodFilterMap".equals(name)) continue;
                field.setAccessible(true);
                field.set(null, new HashMap(0));
                if (++c != 2) continue;
                return;
            }
            throw new RuntimeException("One of field patches did not apply properly. Expected to patch two fields, but patched: " + c);
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException("Unable to patch reflection filters", ex);
        }
    }
}

