/*
 * Decompiled with CFR 0.152.
 */
package pl.skmedix.bootstrap.utils.fx;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ClasspathUtil {
    public static final ClassLoader scl = ClassLoader.getSystemClassLoader();
    private static Tree tree;

    public static Class<?> getSystemClass(String className) throws ClassNotFoundException {
        return Class.forName(className, false, scl);
    }

    public static boolean classExists(String name) {
        try {
            ClasspathUtil.getSystemClass(name);
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public static boolean resourceExists(String path) {
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        return ClasspathUtil.class.getResource(path) != null;
    }

    public static InputStream resource(String path) {
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        return ClasspathUtil.class.getResourceAsStream(path);
    }

    public static class Tree
    implements Comparable<Tree> {
        private final Tree parent;
        private final String value;
        private Map<String, Tree> children;
        private boolean frozen;

        public Tree(Tree parent, String value) {
            this.parent = parent;
            this.value = value;
        }

        private void freeze() {
            this.frozen = true;
            if (this.children != null) {
                this.children.values().forEach(Tree::freeze);
            }
        }

        public Tree visit(String child) {
            if (this.children == null) {
                this.children = new HashMap<String, Tree>();
            }
            if (this.frozen) {
                return this.children.get(child);
            }
            return this.children.computeIfAbsent(child, c -> new Tree(this, (String)c));
        }

        public Tree visitPath(String path) {
            String[] parts = path.split("/");
            return this.visitPath(parts);
        }

        public Tree visitPath(String ... path) {
            Tree node = this;
            for (String part : path) {
                Tree subtree = node.visit(part);
                if (subtree == null) {
                    return null;
                }
                node = subtree;
            }
            return node;
        }

        public List<Tree> getBranches() {
            if (this.children == null) {
                return Collections.singletonList(this);
            }
            ArrayList<Tree> values = new ArrayList<Tree>();
            this.children.values().stream().filter(Tree::isBranch).forEach(values::add);
            return values;
        }

        public List<Tree> getLeaves() {
            if (this.children == null) {
                return Collections.singletonList(this);
            }
            ArrayList<Tree> values = new ArrayList<Tree>();
            this.children.values().stream().filter(Tree::isLeaf).forEach(values::add);
            return values;
        }

        public List<Tree> getAllLeaves() {
            if (this.children == null) {
                return Collections.singletonList(this);
            }
            ArrayList<Tree> values = new ArrayList<Tree>();
            this.children.values().forEach(t -> values.addAll(t.getAllLeaves()));
            return values;
        }

        public Map<String, Tree> getChildren() {
            if (this.children == null) {
                return Collections.emptyMap();
            }
            return this.children;
        }

        public boolean isRoot() {
            return this.parent == null;
        }

        public boolean isLeaf() {
            return this.children == null;
        }

        public boolean isBranch() {
            return !this.isLeaf();
        }

        public Tree getParent() {
            return this.parent;
        }

        public String getValue() {
            return this.value;
        }

        public String getFullValue() {
            if (this.parent == null) {
                return this.getValue();
            }
            if (this.parent.isRoot()) {
                return this.getValue();
            }
            return this.parent.getFullValue() + "/" + this.getValue();
        }

        @Override
        public int compareTo(Tree o) {
            return this.getFullValue().compareTo(o.getFullValue());
        }

        public String toString() {
            return this.getFullValue();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Tree tree = (Tree)o;
            return Objects.equals(this.parent, tree.parent) && this.value.equals(tree.value);
        }

        public int hashCode() {
            return Objects.hash(this.parent, this.value);
        }
    }
}

