/*
 * Decompiled with CFR 0.152.
 */
package pl.skmedix.bootstrap.utils.fx;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import pl.skmedix.bootstrap.Bootstrap;
import pl.skmedix.bootstrap.Log;
import pl.skmedix.bootstrap.downloader.Downloader;
import pl.skmedix.bootstrap.ui.IController;
import pl.skmedix.bootstrap.ui.swing.AlertUtils;
import pl.skmedix.bootstrap.utils.Checksum;
import pl.skmedix.bootstrap.utils.IOUtils;
import pl.skmedix.bootstrap.utils.JavaVersion;
import pl.skmedix.bootstrap.utils.fx.ClassLoaderInternals;
import pl.skmedix.bootstrap.utils.fx.ClasspathUtil;
import pl.skmedix.bootstrap.utils.fx.JFXUtils;
import pl.skmedix.bootstrap.utils.fx.RuntimeProperties;

public class JFXInjection {
    private static final String JFX_CLASSIFIER = JFXInjection.createClassifier();
    private static String JFX_MAVEN;
    private static String JFX_VERSION;
    private static List<String> JFX_DEPENDENCY_URLS;
    private static List<Path> dependencyPaths;
    private static IController controller;

    public static void setController(IController controller) {
        JFXInjection.controller = controller;
    }

    public static void buildDependencyUrlsList(String jfxMaven, String jfxVersion, List<?> dependencies) {
        JFX_MAVEN = jfxMaven;
        JFX_VERSION = jfxVersion;
        JFX_DEPENDENCY_URLS = dependencies.stream().map(dependency -> JFXInjection.jfxUrlPattern((String)dependency)).collect(Collectors.toList());
    }

    public static void ensureJavafxSupport() {
        if (ClasspathUtil.classExists(JFXUtils.getPlatformClassName())) {
            try {
                Class<?> versionClass = Class.forName("com.sun.javafx.runtime.VersionInfo");
                Method setupSystemProperties = versionClass.getDeclaredMethod("setupSystemProperties", new Class[0]);
                setupSystemProperties.setAccessible(true);
                setupSystemProperties.invoke(null, new Object[0]);
            }
            catch (Exception e) {
                Log.error("Failed to setup JavaFX system properties", e);
            }
            Log.debug(String.format("JavaFX initialized: %s", System.getProperty("javafx.version")));
            return;
        }
        if (JavaVersion.get() < 11) {
            JFXInjection.alertPre11UserMissingJFX();
            return;
        }
        if (JavaVersion.get() >= 9) {
            if (dependencyPaths == null) {
                dependencyPaths = JFXInjection.getLocalDependencies();
            }
            JFXInjection.addToClasspath(dependencyPaths);
        }
    }

    public static boolean areLocalDependenciesValid() {
        try {
            Log.info("Checking local cache for JavaFX dependencies...");
            Path dependenciesDirectory = Bootstrap.getCurrentInstance().getLibrariesDirectory();
            if (JFX_DEPENDENCY_URLS.isEmpty()) {
                Log.error("No JavaFX dependencies to check.");
                return false;
            }
            for (String dependencyPattern : JFX_DEPENDENCY_URLS) {
                String remoteHash;
                String dependencyUrlPath = String.format(dependencyPattern, JFX_CLASSIFIER);
                Path dependencyFilePath = dependenciesDirectory.resolve(JFXInjection.getUrlArtifactFileName(dependencyUrlPath));
                Path dependencyFileHashPath = dependenciesDirectory.resolve(JFXInjection.getUrlArtifactFileName(dependencyUrlPath) + ".sha1");
                if (!Files.isRegularFile(dependencyFilePath, new LinkOption[0]) || !Files.isRegularFile(dependencyFileHashPath, new LinkOption[0])) {
                    Log.error("Local JavaFX dependencies are not valid.");
                    return false;
                }
                List<String> files = Files.readAllLines(dependencyFileHashPath);
                String string = remoteHash = files.size() > 0 ? files.get(0) : null;
                if (!Checksum.equals(dependencyFilePath, remoteHash)) {
                    Log.error("Hash mismatch for " + dependencyFilePath.getFileName());
                    Files.deleteIfExists(dependencyFilePath);
                    Files.deleteIfExists(dependencyFileHashPath);
                    return false;
                }
                Log.info("Local JavaFX dependency " + dependencyFilePath.getFileName() + " is valid.");
            }
        }
        catch (IOException ex) {
            Log.error("Failed to write remote dependency to cache", ex);
            JFXInjection.alertUserFailedInit(ex);
        }
        return true;
    }

    public static List<Path> getLocalDependencies() {
        ArrayList<Path> dependencyPaths = new ArrayList<Path>();
        try {
            Log.info("Loading local dependencies, and downloading if needed...");
            Path dependenciesDirectory = Bootstrap.getCurrentInstance().getLibrariesDirectory();
            List oldDependencies = Files.list(dependenciesDirectory).filter(path -> path.getFileName().toString().endsWith(".jar")).collect(Collectors.toList());
            for (String dependencyPattern : JFX_DEPENDENCY_URLS) {
                String dependencyUrlPath = String.format(dependencyPattern, JFX_CLASSIFIER);
                String dependencyUrlHashPath = dependencyUrlPath + ".sha1";
                String fileName = JFXInjection.getUrlArtifactFileName(dependencyUrlPath);
                Path dependencyFilePath = dependenciesDirectory.resolve(fileName);
                Path dependencyFileHashPath = dependenciesDirectory.resolve(fileName + ".sha1");
                oldDependencies.remove(dependencyFilePath);
                if (!IOUtils.isRegularFile(dependencyFilePath) || !IOUtils.isRegularFile(dependencyFileHashPath)) {
                    Log.info(String.format("Downloading JFX artifact: %s", dependencyUrlPath));
                    if (controller != null) {
                        controller.setProgressStatus(String.format("Downloading: %s", fileName));
                    }
                    URL depURL = new URL(dependencyUrlPath);
                    URL depHashURL = new URL(dependencyUrlHashPath);
                    try {
                        Files.copy(depHashURL.openStream(), dependencyFileHashPath, StandardCopyOption.REPLACE_EXISTING);
                    }
                    catch (IOException e) {
                        Log.error("Failed to write remote dependency hash to cache", e);
                        JFXInjection.alertUserFailedInit(e);
                    }
                    Downloader.Controller downloaderController = new Downloader.Controller();
                    new Downloader(controller, depURL, dependencyFilePath, downloaderController).run();
                    try {
                        downloaderController.hasDownloadedLatch.await();
                    }
                    catch (InterruptedException e) {
                        AlertUtils.displayException("Error", "Failed to download JavaFX dependency", e);
                        e.printStackTrace();
                    }
                    dependencyPaths.add(dependencyFilePath);
                    continue;
                }
                dependencyPaths.add(dependencyFilePath);
            }
            if (!oldDependencies.isEmpty()) {
                Log.info("Removing old dependency versions...");
                for (Path existingDependency : oldDependencies) {
                    Files.delete(existingDependency);
                    Files.deleteIfExists(existingDependency.resolveSibling(existingDependency.getFileName() + ".sha1"));
                }
            }
        }
        catch (MalformedURLException ex) {
            Log.error("Invalid dependency URL path", ex);
            JFXInjection.alertUserFailedInit(ex);
        }
        catch (IOException ex) {
            Log.error("Failed to write remote dependency to cache", ex);
            JFXInjection.alertUserFailedInit(ex);
        }
        return dependencyPaths;
    }

    private static void addToClasspath(List<Path> dependencyPaths) {
        try {
            Object ucp = ClassLoaderInternals.getUcp();
            for (Path path : dependencyPaths) {
                URL url = path.toAbsolutePath().toUri().toURL();
                ClassLoaderInternals.appendToUcpPath(ucp, url);
            }
            Log.info("JavaFX classpath injection complete");
        }
        catch (MalformedURLException ex) {
            Log.error("Failed to resolve local dependency jar to URL", ex);
            JFXInjection.alertUserFailedInit(ex);
        }
        catch (ReflectiveOperationException ex) {
            Log.error("Failed to add missing JavaFX paths to classpath", ex);
            JFXInjection.alertUserFailedInit(ex);
        }
    }

    private static void alertPre11UserMissingJFX() {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        toolkit.beep();
        StringWriter writer = new StringWriter();
        RuntimeProperties.dump(writer);
        String debugInfo = writer.toString();
        String message = "<p>The required JavaFX classes could not be found locally.<br><br>Your environment:</p><pre>" + debugInfo + "</pre>";
        message = "BellSoft".equals(System.getProperty("java.vm.vendor", "Unknown")) ? message + "<p>Looks like you installed Liberica 8 Standard JRE/JDK.<br>Please install Liberica 8 <b>Full JDK</b> instead.</p>" : message + "<p>Please make sure that you meet one of the following requirements:<br> 1. Update to Java 17 or 21 <i>(SKlauncher will automatically download JavaFX)</i><br> 2. Use a JDK that bundles JavaFX</p>";
        AlertUtils.showErrorMessageWindow(toolkit, debugInfo, null, message);
        System.exit(1);
    }

    private static void alertUserFailedInit(Exception ex) {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        toolkit.beep();
        StringWriter writer = new StringWriter();
        writer.append("OS: ").append(System.getProperty("os.name")).append("\n");
        writer.append("Version: ").append(System.getProperty("java.version")).append("\n");
        writer.append("Vendor: ").append(System.getProperty("java.vm.vendor")).append("\n\n");
        writer.append("Exception: ");
        ex.printStackTrace(new PrintWriter(writer));
        String errorString = writer.toString();
        StringSelection selection = new StringSelection(errorString);
        Clipboard clipboard = toolkit.getSystemClipboard();
        clipboard.setContents(selection, selection);
        String message = "<p>Something went wrong when trying to load JavaFX.<br><b>The following information about the problem has been copied to your clipboard:</b></p><br><pre>" + errorString + "</pre><p>Please make sure that you meet one of the following requirements:<br> 1. Update to Java 17 or 21 <i>(SKlauncher will automatically download JavaFX)</i><br> 2. Use a JDK that bundles JavaFX</p>";
        AlertUtils.showErrorMessageWindow(toolkit, errorString, null, message);
        System.exit(1);
    }

    private static String getUrlArtifactFileName(String url) {
        return url.substring(url.lastIndexOf(47) + 1);
    }

    private static String jfxUrlPattern(String component) {
        return String.format("%s/org/openjfx/javafx-%s/%s/javafx-%s-%s", JFX_MAVEN, component, JFX_VERSION, component, JFX_VERSION) + "-%s.jar";
    }

    private static String createClassifier() {
        String os = JFXInjection.normalizeOs();
        String arch = JFXInjection.normalizeArch();
        if (os.equals("mac") && arch.equals("aarch64")) {
            return os + "-" + arch;
        }
        if (os.equals("linux") && arch.equals("aarch64")) {
            return os + "-" + arch;
        }
        if (os.equals("win") && arch.equals("x86")) {
            return os + "-" + arch;
        }
        return os;
    }

    private static String normalizeOs() {
        String os = JFXInjection.normalize(RuntimeProperties.OS_NAME);
        if (os.startsWith("macosx") || os.startsWith("osx")) {
            return "mac";
        }
        if (os.startsWith("win")) {
            return "win";
        }
        return "linux";
    }

    private static String normalizeArch() {
        String arch = JFXInjection.normalize(RuntimeProperties.OS_ARCH);
        if ("aarch64".equals(arch)) {
            return "aarch64";
        }
        if (arch.matches("^(arm|arm32)$")) {
            return "arm32";
        }
        if ("x86".equals(arch)) {
            return "x86";
        }
        return arch;
    }

    private static String normalize(String value) {
        return value.toLowerCase().replaceAll("[^a-z0-9]+", "");
    }

    static {
        JFX_DEPENDENCY_URLS = new ArrayList<String>();
    }
}

