/*
 * Decompiled with CFR 0.152.
 */
package pl.skmedix.bootstrap.utils.fx;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.concurrent.atomic.AtomicBoolean;
import pl.skmedix.bootstrap.Log;
import pl.skmedix.bootstrap.utils.JavaVersion;

public class JFXUtils {
    private static final String BASE_PLATFORM = "javafx.application.Platform";
    private static final AtomicBoolean initialized = new AtomicBoolean();

    public static void initializePlatform(Runnable init) {
        if (!initialized.compareAndSet(false, true)) {
            throw new IllegalStateException("Already initialized!");
        }
        try {
            Method m = Class.forName(JFXUtils.getPlatformClassName()).getDeclaredMethod("startup", Runnable.class);
            m.setAccessible(true);
            m.invoke(null, () -> {
                try {
                    init.run();
                }
                finally {
                    JFXUtils.onInitializePlatform();
                }
            });
        }
        catch (NoSuchMethodException ex) {
            throw new IllegalStateException("javafx.application.Platform.startup(Runnable) is missing", ex);
        }
        catch (IllegalAccessException ex) {
            throw new IllegalStateException("'startup' became inaccessible", ex);
        }
        catch (InvocationTargetException ex) {
            throw new IllegalStateException("Unable to initialize toolkit", ex.getTargetException());
        }
        catch (ClassNotFoundException ex) {
            throw new IllegalStateException("Platform class does not contain 'startup' method", ex);
        }
    }

    public static String getPlatformClassName() {
        return JavaVersion.get() >= 9 ? BASE_PLATFORM : "com.sun.javafx.application.PlatformImpl";
    }

    private static void onInitializePlatform() {
        Log.debug(String.format("JavaFX platform initialized from: %s", JFXUtils.getPlatformClassName()));
    }
}

