/*
 * Decompiled with CFR 0.152.
 */
package pl.skmedix.bootstrap.utils.fx;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import pl.skmedix.bootstrap.Log;
import pl.skmedix.bootstrap.utils.fx.ReflectUtil;

public class JigsawUtil {
    private static final MethodHandle CLASS_MODULE;
    private static final MethodHandle CLASS_LOADER_MODULE;
    private static final MethodHandle METHOD_MODIFIERS;
    private static final MethodHandles.Lookup lookup;

    private JigsawUtil() {
    }

    public static MethodHandles.Lookup getLookup() {
        return lookup;
    }

    static Module getClassModule(Class<?> klass) {
        try {
            return CLASS_MODULE.invokeExact(klass);
        }
        catch (Throwable t) {
            Log.error("Failed getting class module: " + klass.getName(), t);
            throw new AssertionError((Object)t);
        }
    }

    static Module getLoaderModule(ClassLoader loader) {
        try {
            return CLASS_LOADER_MODULE.invokeExact(loader);
        }
        catch (Throwable t) {
            Log.error("Failed getting ClassLoader module: " + loader, t);
            throw new AssertionError((Object)t);
        }
    }

    static void setMethodModifiers(Method method, int modifiers) {
        try {
            METHOD_MODIFIERS.invokeExact(method, modifiers);
        }
        catch (Throwable t) {
            Log.error("Failed setting method modifiers: " + method.getName(), t);
            throw new AssertionError((Object)t);
        }
    }

    static {
        try {
            Class<?> unsafeClass = Class.forName("sun.misc.Unsafe");
            Field field = ReflectUtil.getDeclaredField(unsafeClass, "theUnsafe");
            Object unsafe = field.get(null);
            field = MethodHandles.Lookup.class.getDeclaredField("IMPL_LOOKUP");
            MethodHandles.publicLookup();
            Object base = ReflectUtil.quietInvoke(unsafeClass, unsafe, "staticFieldBase", new Class[]{Field.class}, new Object[]{field});
            long offset = (Long)ReflectUtil.quietInvoke(unsafeClass, unsafe, "staticFieldOffset", new Class[]{Field.class}, new Object[]{field});
            lookup = (MethodHandles.Lookup)ReflectUtil.quietInvoke(unsafeClass, unsafe, "getObject", new Class[]{Object.class, Long.TYPE}, new Object[]{base, offset});
            MethodType type = MethodType.methodType(Module.class);
            CLASS_MODULE = lookup.findVirtual(Class.class, "getModule", type);
            CLASS_LOADER_MODULE = lookup.findVirtual(ClassLoader.class, "getUnnamedModule", type);
            METHOD_MODIFIERS = lookup.findSetter(Method.class, "modifiers", Integer.TYPE);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException | NoSuchMethodException ex) {
            throw new ExceptionInInitializerError(ex);
        }
    }
}

