/*
 * Decompiled with CFR 0.152.
 */
package pl.skmedix.bootstrap.utils.fx;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

public final class ReflectUtil {
    private static final Map<Class<?>, ThrowableGetter<?>> GETTERS = new HashMap();
    private static final Map<Class<?>, ThrowableSetter<?>> SETTERS = new HashMap();
    private static final ThrowableGetter<?> DEFAULT_GETTER = ReflectUtil::get;
    private static final ThrowableSetter<?> DEFAULT_SETTER = ReflectUtil::set;

    private ReflectUtil() {
    }

    public static Field getDeclaredField(Class<?> declaringClass, String name) throws NoSuchFieldException {
        Field field = declaringClass.getDeclaredField(name);
        field.setAccessible(true);
        return field;
    }

    public static Method getDeclaredMethod(Class<?> declaringClass, String name, Class<?> ... args) throws NoSuchMethodException {
        Method method = declaringClass.getDeclaredMethod(name, args);
        method.setAccessible(true);
        return method;
    }

    public static <T> void quietSet(Object instance, Field field, T value) {
        try {
            ThrowableSetter<?> setter = SETTERS.getOrDefault(field.getType(), DEFAULT_SETTER);
            setter.set(field, instance, value);
        }
        catch (IllegalAccessException ex) {
            throw new IllegalStateException("Setter failure: " + instance.getClass() + "." + field.getName(), ex);
        }
    }

    public static <T> T quietGet(Object instance, Field field) {
        try {
            ThrowableGetter<?> getter = GETTERS.getOrDefault(field.getType(), DEFAULT_GETTER);
            return (T)getter.get(field, instance);
        }
        catch (IllegalAccessException ex) {
            throw new IllegalStateException("Getter failure: " + instance.getClass() + "." + field.getName(), ex);
        }
    }

    public static <T> T quietNew(Class<T> type, Class<?>[] argTypes, Object[] args) {
        try {
            Constructor<T> constructor = type.getDeclaredConstructor(argTypes);
            constructor.setAccessible(true);
            return constructor.newInstance(args);
        }
        catch (ReflectiveOperationException ex) {
            throw new IllegalStateException("Constructor failure: " + type.getName(), ex);
        }
    }

    public static <T> T quietInvoke(Class<?> type, Object instance, String name, Class<?>[] argTypes, Object[] args) {
        try {
            Method method = type.getDeclaredMethod(name, argTypes);
            method.setAccessible(true);
            return (T)method.invoke(instance, args);
        }
        catch (ReflectiveOperationException ex) {
            throw new IllegalStateException("Invoke failure: " + type.getName(), ex);
        }
    }

    public static void copyTo(Object from, Object to) {
        if (from == null || to == null) {
            return;
        }
        Class<?> type = to.getClass();
        if (!type.equals(from.getClass())) {
            return;
        }
        for (Field field : type.getDeclaredFields()) {
            if ((field.getModifiers() & 8) > 0) continue;
            field.setAccessible(true);
            Object value = ReflectUtil.quietGet(from, field);
            ReflectUtil.quietSet(to, field, value);
        }
    }

    public static <X extends Throwable> void propagate(Throwable t) throws X {
        throw t;
    }

    private static Object get(Field field, Object instance) throws IllegalAccessException {
        field.setAccessible(true);
        return field.get(instance);
    }

    private static void set(Field field, Object instance, Object value) throws IllegalAccessException {
        field.setAccessible(true);
        field.set(instance, value);
    }

    static {
        GETTERS.put(Boolean.TYPE, Field::getBoolean);
        GETTERS.put(Byte.TYPE, Field::getByte);
        GETTERS.put(Character.TYPE, Field::getChar);
        GETTERS.put(Short.TYPE, Field::getShort);
        GETTERS.put(Integer.TYPE, Field::getInt);
        GETTERS.put(Long.TYPE, Field::getLong);
        GETTERS.put(Float.TYPE, Field::getFloat);
        GETTERS.put(Double.TYPE, Field::getDouble);
        SETTERS.put(Boolean.TYPE, Field::setBoolean);
        SETTERS.put(Byte.TYPE, Field::setByte);
        SETTERS.put(Character.TYPE, Field::setChar);
        SETTERS.put(Short.TYPE, Field::setShort);
        SETTERS.put(Integer.TYPE, Field::setInt);
        SETTERS.put(Long.TYPE, Field::setLong);
        SETTERS.put(Float.TYPE, Field::setFloat);
        SETTERS.put(Double.TYPE, Field::setDouble);
    }

    static interface ThrowableSetter<T> {
        public void set(Field var1, Object var2, T var3) throws IllegalAccessException;
    }

    static interface ThrowableGetter<T> {
        public T get(Field var1, Object var2) throws IllegalAccessException;
    }
}

