/*
 * Decompiled with CFR 0.152.
 */
package pl.skmedix.bootstrap.utils.fx;

import java.io.StringWriter;
import java.util.Map;
import java.util.TreeMap;

public class RuntimeProperties {
    private static final String KEY_OS_NAME = "os.name";
    private static final String KEY_OS_ARCH = "os.arch";
    private static final String KEY_OS_VERSION = "os.version";
    private static final String KEY_OS_ARCH_BITS = "os.bitness";
    private static final String KEY_JAVA_VERSION = "java.version";
    private static final String KEY_JAVA_VM_NAME = "java.vm.version";
    private static final String KEY_JAVA_VM_VENDOR = "java.vm.vendor";
    private static final String KEY_JAVA_HOME = "java.home";
    public static final String OS_NAME = System.getProperty("os.name");
    public static final String OS_ARCH = System.getProperty("os.arch");
    public static final int OS_ARCH_BITS = RuntimeProperties.determineBitness();
    public static final String OS_VERSION = System.getProperty("os.version");
    public static final String JAVA_VERSION = System.getProperty("java.version");
    public static final String JAVA_VM_NAME = System.getProperty("java.vm.version");
    public static final String JAVA_VM_VENDOR = System.getProperty("java.vm.vendor");
    public static final String JAVA_HOME = System.getProperty("java.home");
    private static final Map<String, String> ALL_PROPERTIES = new TreeMap<String, String>(){
        {
            this.put(RuntimeProperties.KEY_OS_NAME, OS_NAME);
            this.put(RuntimeProperties.KEY_OS_ARCH, OS_ARCH);
            this.put(RuntimeProperties.KEY_OS_ARCH_BITS, String.valueOf(OS_ARCH_BITS));
            this.put(RuntimeProperties.KEY_OS_VERSION, OS_VERSION);
            this.put(RuntimeProperties.KEY_JAVA_VERSION, JAVA_VERSION);
            this.put(RuntimeProperties.KEY_JAVA_VM_NAME, JAVA_VM_NAME);
            this.put(RuntimeProperties.KEY_JAVA_VM_VENDOR, JAVA_VM_VENDOR);
            this.put(RuntimeProperties.KEY_JAVA_HOME, JAVA_HOME);
        }
    };

    private static int determineBitness() {
        String bitness = System.getProperty("sun.arch.data.model", "");
        if (bitness.matches("[0-9]{2}")) {
            return Integer.parseInt(bitness, 10);
        }
        bitness = System.getProperty("com.ibm.vm.bitmode", "");
        if (bitness.matches("[0-9]{2}")) {
            return Integer.parseInt(bitness, 10);
        }
        return OS_ARCH.contains("64") ? 64 : 32;
    }

    public static void dump(StringWriter writer) {
        if (writer != null) {
            ALL_PROPERTIES.forEach((key, value) -> writer.append(String.format("%s = %s\n", key, value)));
        }
    }
}

