/*
 * Decompiled with CFR 0.152.
 */
package pl.skmedix.bootstrap.utils.fx;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;

public class ThreadPoolFactory {
    private static final int MAX = Math.max(2, Runtime.getRuntime().availableProcessors() - 2);

    public static ScheduledExecutorService newScheduledThreadPool(String name) {
        return ThreadPoolFactory.newScheduledThreadPool(name, true);
    }

    public static ScheduledExecutorService newScheduledThreadPool(String name, boolean daemon) {
        return Executors.newScheduledThreadPool(MAX, new FactoryImpl(name, daemon));
    }

    private static class FactoryImpl
    implements ThreadFactory {
        private final String name;
        private final boolean daemon;
        private int tid = 0;

        public FactoryImpl(String name, boolean daemon) {
            this.name = name;
            this.daemon = daemon;
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = new Thread(r);
            thread.setDaemon(this.daemon);
            thread.setName(this.name + "-" + this.tid++);
            return thread;
        }
    }
}

